
package me.snowdrop.istio.mixer.adapter.opa;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.internal.MixerAdapter;
import me.snowdrop.istio.api.policy.v1beta1.HandlerParams;


/**
 * 
 */
@MixerAdapter(compiledAdapter = "opa")
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "checkMethod",
    "failClose",
    "policy"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Opa implements Serializable, HandlerParams
{

    /**
     * 
     */
    @JsonProperty("checkMethod")
    @JsonPropertyDescription("")
    private String checkMethod;
    /**
     * 
     */
    @JsonProperty("failClose")
    @JsonPropertyDescription("")
    private Boolean failClose;
    /**
     * 
     */
    @JsonProperty("policy")
    @JsonPropertyDescription("")
    private List<String> policy = new ArrayList<String>();
    private final static long serialVersionUID = -6657898103649153010L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Opa() {
    }

    /**
     * 
     * @param failClose
     * @param checkMethod
     * @param policy
     */
    public Opa(String checkMethod, Boolean failClose, List<String> policy) {
        super();
        this.checkMethod = checkMethod;
        this.failClose = failClose;
        this.policy = policy;
    }

    /**
     * 
     */
    public String getCheckMethod() {
        return checkMethod;
    }

    /**
     * 
     */
    public void setCheckMethod(String checkMethod) {
        this.checkMethod = checkMethod;
    }

    /**
     * 
     */
    public Boolean getFailClose() {
        return failClose;
    }

    /**
     * 
     */
    public void setFailClose(Boolean failClose) {
        this.failClose = failClose;
    }

    /**
     * 
     */
    public List<String> getPolicy() {
        return policy;
    }

    /**
     * 
     */
    public void setPolicy(List<String> policy) {
        this.policy = policy;
    }

}
