package me.snowdrop.istio.mixer.adapter.opa;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OpaBuilder extends OpaFluentImpl<OpaBuilder> implements VisitableBuilder<Opa,OpaBuilder>{

    OpaFluent<?> fluent;
    Boolean validationEnabled;

    public OpaBuilder(){
            this(true);
    }
    public OpaBuilder(Boolean validationEnabled){
            this(new Opa(), validationEnabled);
    }
    public OpaBuilder(OpaFluent<?> fluent){
            this(fluent, true);
    }
    public OpaBuilder(OpaFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Opa(), validationEnabled);
    }
    public OpaBuilder(OpaFluent<?> fluent,Opa instance){
            this(fluent, instance, true);
    }
    public OpaBuilder(OpaFluent<?> fluent,Opa instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCheckMethod(instance.getCheckMethod()); 
            fluent.withFailClose(instance.getFailClose()); 
            fluent.withPolicy(instance.getPolicy()); 
            this.validationEnabled = validationEnabled; 
    }
    public OpaBuilder(Opa instance){
            this(instance,true);
    }
    public OpaBuilder(Opa instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCheckMethod(instance.getCheckMethod()); 
            this.withFailClose(instance.getFailClose()); 
            this.withPolicy(instance.getPolicy()); 
            this.validationEnabled = validationEnabled; 
    }

    public Opa build(){
            Opa buildable = new Opa(fluent.getCheckMethod(),fluent.isFailClose(),fluent.getPolicy());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            OpaBuilder that = (OpaBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
