package me.snowdrop.istio.mixer.adapter.opa;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class OpaFluentImpl<A extends OpaFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements OpaFluent<A>{

    private String checkMethod;
    private Boolean failClose;
    private List<String> policy;

    public OpaFluentImpl(){
    }
    public OpaFluentImpl(Opa instance){
            this.withCheckMethod(instance.getCheckMethod()); 
            this.withFailClose(instance.getFailClose()); 
            this.withPolicy(instance.getPolicy()); 
    }

    public String getCheckMethod(){
            return this.checkMethod;
    }

    public A withCheckMethod(String checkMethod){
            this.checkMethod=checkMethod; return (A) this;
    }

    public Boolean hasCheckMethod(){
            return this.checkMethod != null;
    }

    public A withNewCheckMethod(String arg1){
            return (A)withCheckMethod(new String(arg1));
    }

    public A withNewCheckMethod(StringBuilder arg1){
            return (A)withCheckMethod(new String(arg1));
    }

    public A withNewCheckMethod(StringBuffer arg1){
            return (A)withCheckMethod(new String(arg1));
    }

    public Boolean isFailClose(){
            return this.failClose;
    }

    public A withFailClose(Boolean failClose){
            this.failClose=failClose; return (A) this;
    }

    public Boolean hasFailClose(){
            return this.failClose != null;
    }

    public A withNewFailClose(String arg1){
            return (A)withFailClose(new Boolean(arg1));
    }

    public A withNewFailClose(boolean arg1){
            return (A)withFailClose(new Boolean(arg1));
    }

    public A addToPolicy(int index,String item){
            if (this.policy == null) {this.policy = new ArrayList<String>();}
            this.policy.add(index, item);
            return (A)this;
    }

    public A setToPolicy(int index,String item){
            if (this.policy == null) {this.policy = new ArrayList<String>();}
            this.policy.set(index, item); return (A)this;
    }

    public A addToPolicy(String... items){
            if (this.policy == null) {this.policy = new ArrayList<String>();}
            for (String item : items) {this.policy.add(item);} return (A)this;
    }

    public A addAllToPolicy(Collection<String> items){
            if (this.policy == null) {this.policy = new ArrayList<String>();}
            for (String item : items) {this.policy.add(item);} return (A)this;
    }

    public A removeFromPolicy(String... items){
            for (String item : items) {if (this.policy!= null){ this.policy.remove(item);}} return (A)this;
    }

    public A removeAllFromPolicy(Collection<String> items){
            for (String item : items) {if (this.policy!= null){ this.policy.remove(item);}} return (A)this;
    }

    public List<String> getPolicy(){
            return this.policy;
    }

    public String getPolicy(int index){
            return this.policy.get(index);
    }

    public String getFirstPolicy(){
            return this.policy.get(0);
    }

    public String getLastPolicy(){
            return this.policy.get(policy.size() - 1);
    }

    public String getMatchingPolicy(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: policy) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingPolicy(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: policy) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withPolicy(List<String> policy){
            if (this.policy != null) { _visitables.get("policy").removeAll(this.policy);}
            if (policy != null) {this.policy = new ArrayList<String>(); for (String item : policy){this.addToPolicy(item);}} else { this.policy = null;} return (A) this;
    }

    public A withPolicy(String... policy){
            if (this.policy != null) {this.policy.clear();}
            if (policy != null) {for (String item :policy){ this.addToPolicy(item);}} return (A) this;
    }

    public Boolean hasPolicy(){
            return policy != null && !policy.isEmpty();
    }

    public A addNewPolicy(String arg1){
            return (A)addToPolicy(new String(arg1));
    }

    public A addNewPolicy(StringBuilder arg1){
            return (A)addToPolicy(new String(arg1));
    }

    public A addNewPolicy(StringBuffer arg1){
            return (A)addToPolicy(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            OpaFluentImpl that = (OpaFluentImpl) o;
            if (checkMethod != null ? !checkMethod.equals(that.checkMethod) :that.checkMethod != null) return false;
            if (failClose != null ? !failClose.equals(that.failClose) :that.failClose != null) return false;
            if (policy != null ? !policy.equals(that.policy) :that.policy != null) return false;
            return true;
    }




}
