
package me.snowdrop.istio.mixer.adapter.prometheus;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.mixer.adapter.prometheus.BucketsDefinition.Definition;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "explicitBuckets"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class ExplicitBucketsDefinition implements Serializable, Definition
{

    /**
     * 
     */
    @JsonProperty("explicitBuckets")
    @JsonPropertyDescription("")
    private Explicit explicitBuckets;
    private final static long serialVersionUID = 1250897602785481724L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ExplicitBucketsDefinition() {
    }

    /**
     * 
     * @param explicitBuckets
     */
    public ExplicitBucketsDefinition(Explicit explicitBuckets) {
        super();
        this.explicitBuckets = explicitBuckets;
    }

    /**
     * 
     */
    public Explicit getExplicitBuckets() {
        return explicitBuckets;
    }

    /**
     * 
     */
    public void setExplicitBuckets(Explicit explicitBuckets) {
        this.explicitBuckets = explicitBuckets;
    }

}
