
package me.snowdrop.istio.mixer.adapter.prometheus;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "growthFactor",
    "numFiniteBuckets",
    "scale"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Exponential implements Serializable
{

    /**
     * 
     */
    @JsonProperty("growthFactor")
    @JsonPropertyDescription("")
    private Double growthFactor;
    /**
     * 
     */
    @JsonProperty("numFiniteBuckets")
    @JsonPropertyDescription("")
    private Integer numFiniteBuckets;
    /**
     * 
     */
    @JsonProperty("scale")
    @JsonPropertyDescription("")
    private Double scale;
    private final static long serialVersionUID = 5739560187166983672L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Exponential() {
    }

    /**
     * 
     * @param growthFactor
     * @param scale
     * @param numFiniteBuckets
     */
    public Exponential(Double growthFactor, Integer numFiniteBuckets, Double scale) {
        super();
        this.growthFactor = growthFactor;
        this.numFiniteBuckets = numFiniteBuckets;
        this.scale = scale;
    }

    /**
     * 
     */
    public Double getGrowthFactor() {
        return growthFactor;
    }

    /**
     * 
     */
    public void setGrowthFactor(Double growthFactor) {
        this.growthFactor = growthFactor;
    }

    /**
     * 
     */
    public Integer getNumFiniteBuckets() {
        return numFiniteBuckets;
    }

    /**
     * 
     */
    public void setNumFiniteBuckets(Integer numFiniteBuckets) {
        this.numFiniteBuckets = numFiniteBuckets;
    }

    /**
     * 
     */
    public Double getScale() {
        return scale;
    }

    /**
     * 
     */
    public void setScale(Double scale) {
        this.scale = scale;
    }

}
