
package me.snowdrop.istio.mixer.adapter.prometheus;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "numFiniteBuckets",
    "offset",
    "width"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Linear implements Serializable
{

    /**
     * 
     */
    @JsonProperty("numFiniteBuckets")
    @JsonPropertyDescription("")
    private Integer numFiniteBuckets;
    /**
     * 
     */
    @JsonProperty("offset")
    @JsonPropertyDescription("")
    private Double offset;
    /**
     * 
     */
    @JsonProperty("width")
    @JsonPropertyDescription("")
    private Double width;
    private final static long serialVersionUID = -8330507528815756657L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Linear() {
    }

    /**
     * 
     * @param offset
     * @param width
     * @param numFiniteBuckets
     */
    public Linear(Integer numFiniteBuckets, Double offset, Double width) {
        super();
        this.numFiniteBuckets = numFiniteBuckets;
        this.offset = offset;
        this.width = width;
    }

    /**
     * 
     */
    public Integer getNumFiniteBuckets() {
        return numFiniteBuckets;
    }

    /**
     * 
     */
    public void setNumFiniteBuckets(Integer numFiniteBuckets) {
        this.numFiniteBuckets = numFiniteBuckets;
    }

    /**
     * 
     */
    public Double getOffset() {
        return offset;
    }

    /**
     * 
     */
    public void setOffset(Double offset) {
        this.offset = offset;
    }

    /**
     * 
     */
    public Double getWidth() {
        return width;
    }

    /**
     * 
     */
    public void setWidth(Double width) {
        this.width = width;
    }

}
