
package me.snowdrop.istio.mixer.adapter.prometheus;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "expiryCheckIntervalDuration",
    "metricsExpiryDuration"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class MetricsExpirationPolicy implements Serializable
{

    /**
     * 
     */
    @JsonProperty("expiryCheckIntervalDuration")
    @JsonPropertyDescription("")
    private Integer expiryCheckIntervalDuration;
    /**
     * 
     */
    @JsonProperty("metricsExpiryDuration")
    @JsonPropertyDescription("")
    private Integer metricsExpiryDuration;
    private final static long serialVersionUID = -6985036780006722014L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public MetricsExpirationPolicy() {
    }

    /**
     * 
     * @param expiryCheckIntervalDuration
     * @param metricsExpiryDuration
     */
    public MetricsExpirationPolicy(Integer expiryCheckIntervalDuration, Integer metricsExpiryDuration) {
        super();
        this.expiryCheckIntervalDuration = expiryCheckIntervalDuration;
        this.metricsExpiryDuration = metricsExpiryDuration;
    }

    /**
     * 
     */
    public Integer getExpiryCheckIntervalDuration() {
        return expiryCheckIntervalDuration;
    }

    /**
     * 
     */
    public void setExpiryCheckIntervalDuration(Integer expiryCheckIntervalDuration) {
        this.expiryCheckIntervalDuration = expiryCheckIntervalDuration;
    }

    /**
     * 
     */
    public Integer getMetricsExpiryDuration() {
        return metricsExpiryDuration;
    }

    /**
     * 
     */
    public void setMetricsExpiryDuration(Integer metricsExpiryDuration) {
        this.metricsExpiryDuration = metricsExpiryDuration;
    }

}
