package me.snowdrop.istio.mixer.adapter.prometheus;

import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class MetricsExpirationPolicyFluentImpl<A extends MetricsExpirationPolicyFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements MetricsExpirationPolicyFluent<A>{

    private Integer expiryCheckIntervalDuration;
    private Integer metricsExpiryDuration;

    public MetricsExpirationPolicyFluentImpl(){
    }
    public MetricsExpirationPolicyFluentImpl(MetricsExpirationPolicy instance){
            this.withExpiryCheckIntervalDuration(instance.getExpiryCheckIntervalDuration()); 
            this.withMetricsExpiryDuration(instance.getMetricsExpiryDuration()); 
    }

    public Integer getExpiryCheckIntervalDuration(){
            return this.expiryCheckIntervalDuration;
    }

    public A withExpiryCheckIntervalDuration(Integer expiryCheckIntervalDuration){
            this.expiryCheckIntervalDuration=expiryCheckIntervalDuration; return (A) this;
    }

    public Boolean hasExpiryCheckIntervalDuration(){
            return this.expiryCheckIntervalDuration != null;
    }

    public Integer getMetricsExpiryDuration(){
            return this.metricsExpiryDuration;
    }

    public A withMetricsExpiryDuration(Integer metricsExpiryDuration){
            this.metricsExpiryDuration=metricsExpiryDuration; return (A) this;
    }

    public Boolean hasMetricsExpiryDuration(){
            return this.metricsExpiryDuration != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            MetricsExpirationPolicyFluentImpl that = (MetricsExpirationPolicyFluentImpl) o;
            if (expiryCheckIntervalDuration != null ? !expiryCheckIntervalDuration.equals(that.expiryCheckIntervalDuration) :that.expiryCheckIntervalDuration != null) return false;
            if (metricsExpiryDuration != null ? !metricsExpiryDuration.equals(that.metricsExpiryDuration) :that.metricsExpiryDuration != null) return false;
            return true;
    }




}
