
package me.snowdrop.istio.mixer.adapter.prometheus;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.internal.MixerAdapter;
import me.snowdrop.istio.api.policy.v1beta1.HandlerParams;


/**
 * 
 */
@MixerAdapter(compiledAdapter = "prometheus")
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "metrics",
    "metricsExpirationPolicy"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Prometheus implements Serializable, HandlerParams
{

    /**
     * 
     */
    @JsonProperty("metrics")
    @JsonPropertyDescription("")
    private List<MetricInfo> metrics = new ArrayList<MetricInfo>();
    /**
     * 
     */
    @JsonProperty("metricsExpirationPolicy")
    @JsonPropertyDescription("")
    private MetricsExpirationPolicy metricsExpirationPolicy;
    private final static long serialVersionUID = 9078812067957757246L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Prometheus() {
    }

    /**
     * 
     * @param metrics
     * @param metricsExpirationPolicy
     */
    public Prometheus(List<MetricInfo> metrics, MetricsExpirationPolicy metricsExpirationPolicy) {
        super();
        this.metrics = metrics;
        this.metricsExpirationPolicy = metricsExpirationPolicy;
    }

    /**
     * 
     */
    public List<MetricInfo> getMetrics() {
        return metrics;
    }

    /**
     * 
     */
    public void setMetrics(List<MetricInfo> metrics) {
        this.metrics = metrics;
    }

    /**
     * 
     */
    public MetricsExpirationPolicy getMetricsExpirationPolicy() {
        return metricsExpirationPolicy;
    }

    /**
     * 
     */
    public void setMetricsExpirationPolicy(MetricsExpirationPolicy metricsExpirationPolicy) {
        this.metricsExpirationPolicy = metricsExpirationPolicy;
    }

}
