package me.snowdrop.istio.mixer.adapter.redisquota;

import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

public class OverrideFluentImpl<A extends me.snowdrop.istio.mixer.adapter.redisquota.OverrideFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements me.snowdrop.istio.mixer.adapter.redisquota.OverrideFluent<A>{

    private Map<String,String> dimensions;
    private Integer maxAmount;

    public OverrideFluentImpl(){
    }
    public OverrideFluentImpl(me.snowdrop.istio.mixer.adapter.redisquota.Override instance){
            this.withDimensions(instance.getDimensions()); 
            this.withMaxAmount(instance.getMaxAmount()); 
    }

    public A addToDimensions(String key,String value){
            if(this.dimensions == null && key != null && value != null) { this.dimensions = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.dimensions.put(key, value);} return (A)this;
    }

    public A addToDimensions(Map<String,String> map){
            if(this.dimensions == null && map != null) { this.dimensions = new LinkedHashMap<String,String>(); }
            if(map != null) { this.dimensions.putAll(map);} return (A)this;
    }

    public A removeFromDimensions(String key){
            if(this.dimensions == null) { return (A) this; }
            if(key != null && this.dimensions != null) {this.dimensions.remove(key);} return (A)this;
    }

    public A removeFromDimensions(Map<String,String> map){
            if(this.dimensions == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.dimensions != null){this.dimensions.remove(key);}}} return (A)this;
    }

    public Map<String,String> getDimensions(){
            return this.dimensions;
    }

    public A withDimensions(Map<String,String> dimensions){
            if (dimensions == null) { this.dimensions =  null;} else {this.dimensions = new LinkedHashMap<String,String>(dimensions);} return (A) this;
    }

    public Boolean hasDimensions(){
            return this.dimensions != null;
    }

    public Integer getMaxAmount(){
            return this.maxAmount;
    }

    public A withMaxAmount(Integer maxAmount){
            this.maxAmount=maxAmount; return (A) this;
    }

    public Boolean hasMaxAmount(){
            return this.maxAmount != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            OverrideFluentImpl that = (OverrideFluentImpl) o;
            if (dimensions != null ? !dimensions.equals(that.dimensions) :that.dimensions != null) return false;
            if (maxAmount != null ? !maxAmount.equals(that.maxAmount) :that.maxAmount != null) return false;
            return true;
    }




}
