
package me.snowdrop.istio.mixer.adapter.redisquota;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "bucketDuration",
    "maxAmount",
    "name",
    "overrides",
    "rateLimitAlgorithm",
    "validDuration"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Quota implements Serializable
{

    /**
     * 
     */
    @JsonProperty("bucketDuration")
    @JsonPropertyDescription("")
    private Integer bucketDuration;
    /**
     * 
     */
    @JsonProperty("maxAmount")
    @JsonPropertyDescription("")
    private Integer maxAmount;
    /**
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("")
    private String name;
    /**
     * 
     */
    @JsonProperty("overrides")
    @JsonPropertyDescription("")
    private List<Override> overrides = new ArrayList<Override>();
    @JsonProperty("rateLimitAlgorithm")
    private QuotaAlgorithm rateLimitAlgorithm;
    /**
     * 
     */
    @JsonProperty("validDuration")
    @JsonPropertyDescription("")
    private Integer validDuration;
    private final static long serialVersionUID = -912249545224411633L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Quota() {
    }

    /**
     * 
     * @param bucketDuration
     * @param name
     * @param rateLimitAlgorithm
     * @param validDuration
     * @param overrides
     * @param maxAmount
     */
    public Quota(Integer bucketDuration, Integer maxAmount, String name, List<Override> overrides, QuotaAlgorithm rateLimitAlgorithm, Integer validDuration) {
        super();
        this.bucketDuration = bucketDuration;
        this.maxAmount = maxAmount;
        this.name = name;
        this.overrides = overrides;
        this.rateLimitAlgorithm = rateLimitAlgorithm;
        this.validDuration = validDuration;
    }

    /**
     * 
     */
    public Integer getBucketDuration() {
        return bucketDuration;
    }

    /**
     * 
     */
    public void setBucketDuration(Integer bucketDuration) {
        this.bucketDuration = bucketDuration;
    }

    /**
     * 
     */
    public Integer getMaxAmount() {
        return maxAmount;
    }

    /**
     * 
     */
    public void setMaxAmount(Integer maxAmount) {
        this.maxAmount = maxAmount;
    }

    /**
     * 
     */
    public String getName() {
        return name;
    }

    /**
     * 
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 
     */
    public List<Override> getOverrides() {
        return overrides;
    }

    /**
     * 
     */
    public void setOverrides(List<Override> overrides) {
        this.overrides = overrides;
    }

    public QuotaAlgorithm getRateLimitAlgorithm() {
        return rateLimitAlgorithm;
    }

    public void setRateLimitAlgorithm(QuotaAlgorithm rateLimitAlgorithm) {
        this.rateLimitAlgorithm = rateLimitAlgorithm;
    }

    /**
     * 
     */
    public Integer getValidDuration() {
        return validDuration;
    }

    /**
     * 
     */
    public void setValidDuration(Integer validDuration) {
        this.validDuration = validDuration;
    }

}
