
package me.snowdrop.istio.mixer.adapter.redisquota;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.internal.MixerAdapter;
import me.snowdrop.istio.api.policy.v1beta1.HandlerParams;


/**
 * 
 */
@MixerAdapter(compiledAdapter = "redisquota")
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "connectionPoolSize",
    "quotas",
    "redisServerUrl"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Redisquota implements Serializable, HandlerParams
{

    /**
     * 
     */
    @JsonProperty("connectionPoolSize")
    @JsonPropertyDescription("")
    private Integer connectionPoolSize;
    /**
     * 
     */
    @JsonProperty("quotas")
    @JsonPropertyDescription("")
    private List<Quota> quotas = new ArrayList<Quota>();
    /**
     * 
     */
    @JsonProperty("redisServerUrl")
    @JsonPropertyDescription("")
    private String redisServerUrl;
    private final static long serialVersionUID = -4446630530248574508L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Redisquota() {
    }

    /**
     * 
     * @param quotas
     * @param redisServerUrl
     * @param connectionPoolSize
     */
    public Redisquota(Integer connectionPoolSize, List<Quota> quotas, String redisServerUrl) {
        super();
        this.connectionPoolSize = connectionPoolSize;
        this.quotas = quotas;
        this.redisServerUrl = redisServerUrl;
    }

    /**
     * 
     */
    public Integer getConnectionPoolSize() {
        return connectionPoolSize;
    }

    /**
     * 
     */
    public void setConnectionPoolSize(Integer connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
    }

    /**
     * 
     */
    public List<Quota> getQuotas() {
        return quotas;
    }

    /**
     * 
     */
    public void setQuotas(List<Quota> quotas) {
        this.quotas = quotas;
    }

    /**
     * 
     */
    public String getRedisServerUrl() {
        return redisServerUrl;
    }

    /**
     * 
     */
    public void setRedisServerUrl(String redisServerUrl) {
        this.redisServerUrl = redisServerUrl;
    }

}
