
package me.snowdrop.istio.mixer.adapter.solarwinds;

import java.io.Serializable;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.internal.MixerAdapter;
import me.snowdrop.istio.api.policy.v1beta1.HandlerParams;


/**
 * 
 */
@MixerAdapter(compiledAdapter = "solarwinds")
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "appopticsAccessToken",
    "appopticsBatchSize",
    "logs",
    "metrics",
    "papertrailLocalRetentionDuration",
    "papertrailUrl"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Solarwinds implements Serializable, HandlerParams
{

    /**
     * 
     */
    @JsonProperty("appopticsAccessToken")
    @JsonPropertyDescription("")
    private java.lang.String appopticsAccessToken;
    /**
     * 
     */
    @JsonProperty("appopticsBatchSize")
    @JsonPropertyDescription("")
    private Integer appopticsBatchSize;
    /**
     * 
     */
    @JsonProperty("logs")
    @JsonPropertyDescription("")
    private Map<String, LogInfo> logs;
    /**
     * 
     */
    @JsonProperty("metrics")
    @JsonPropertyDescription("")
    private Map<String, MetricInfo> metrics;
    /**
     * 
     */
    @JsonProperty("papertrailLocalRetentionDuration")
    @JsonPropertyDescription("")
    private Integer papertrailLocalRetentionDuration;
    /**
     * 
     */
    @JsonProperty("papertrailUrl")
    @JsonPropertyDescription("")
    private java.lang.String papertrailUrl;
    private final static long serialVersionUID = -5767374529115546980L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Solarwinds() {
    }

    /**
     * 
     * @param papertrailLocalRetentionDuration
     * @param appopticsAccessToken
     * @param papertrailUrl
     * @param metrics
     * @param appopticsBatchSize
     * @param logs
     */
    public Solarwinds(java.lang.String appopticsAccessToken, Integer appopticsBatchSize, Map<String, LogInfo> logs, Map<String, MetricInfo> metrics, Integer papertrailLocalRetentionDuration, java.lang.String papertrailUrl) {
        super();
        this.appopticsAccessToken = appopticsAccessToken;
        this.appopticsBatchSize = appopticsBatchSize;
        this.logs = logs;
        this.metrics = metrics;
        this.papertrailLocalRetentionDuration = papertrailLocalRetentionDuration;
        this.papertrailUrl = papertrailUrl;
    }

    /**
     * 
     */
    public java.lang.String getAppopticsAccessToken() {
        return appopticsAccessToken;
    }

    /**
     * 
     */
    public void setAppopticsAccessToken(java.lang.String appopticsAccessToken) {
        this.appopticsAccessToken = appopticsAccessToken;
    }

    /**
     * 
     */
    public Integer getAppopticsBatchSize() {
        return appopticsBatchSize;
    }

    /**
     * 
     */
    public void setAppopticsBatchSize(Integer appopticsBatchSize) {
        this.appopticsBatchSize = appopticsBatchSize;
    }

    /**
     * 
     */
    public Map<String, LogInfo> getLogs() {
        return logs;
    }

    /**
     * 
     */
    public void setLogs(Map<String, LogInfo> logs) {
        this.logs = logs;
    }

    /**
     * 
     */
    public Map<String, MetricInfo> getMetrics() {
        return metrics;
    }

    /**
     * 
     */
    public void setMetrics(Map<String, MetricInfo> metrics) {
        this.metrics = metrics;
    }

    /**
     * 
     */
    public Integer getPapertrailLocalRetentionDuration() {
        return papertrailLocalRetentionDuration;
    }

    /**
     * 
     */
    public void setPapertrailLocalRetentionDuration(Integer papertrailLocalRetentionDuration) {
        this.papertrailLocalRetentionDuration = papertrailLocalRetentionDuration;
    }

    /**
     * 
     */
    public java.lang.String getPapertrailUrl() {
        return papertrailUrl;
    }

    /**
     * 
     */
    public void setPapertrailUrl(java.lang.String papertrailUrl) {
        this.papertrailUrl = papertrailUrl;
    }

}
