package me.snowdrop.istio.mixer.adapter.solarwinds;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SolarwindsBuilder extends SolarwindsFluentImpl<SolarwindsBuilder> implements VisitableBuilder<Solarwinds,SolarwindsBuilder>{

    SolarwindsFluent<?> fluent;
    Boolean validationEnabled;

    public SolarwindsBuilder(){
            this(true);
    }
    public SolarwindsBuilder(Boolean validationEnabled){
            this(new Solarwinds(), validationEnabled);
    }
    public SolarwindsBuilder(SolarwindsFluent<?> fluent){
            this(fluent, true);
    }
    public SolarwindsBuilder(SolarwindsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Solarwinds(), validationEnabled);
    }
    public SolarwindsBuilder(SolarwindsFluent<?> fluent,Solarwinds instance){
            this(fluent, instance, true);
    }
    public SolarwindsBuilder(SolarwindsFluent<?> fluent,Solarwinds instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAppopticsAccessToken(instance.getAppopticsAccessToken()); 
            fluent.withAppopticsBatchSize(instance.getAppopticsBatchSize()); 
            fluent.withLogs(instance.getLogs()); 
            fluent.withMetrics(instance.getMetrics()); 
            fluent.withPapertrailLocalRetentionDuration(instance.getPapertrailLocalRetentionDuration()); 
            fluent.withPapertrailUrl(instance.getPapertrailUrl()); 
            this.validationEnabled = validationEnabled; 
    }
    public SolarwindsBuilder(Solarwinds instance){
            this(instance,true);
    }
    public SolarwindsBuilder(Solarwinds instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAppopticsAccessToken(instance.getAppopticsAccessToken()); 
            this.withAppopticsBatchSize(instance.getAppopticsBatchSize()); 
            this.withLogs(instance.getLogs()); 
            this.withMetrics(instance.getMetrics()); 
            this.withPapertrailLocalRetentionDuration(instance.getPapertrailLocalRetentionDuration()); 
            this.withPapertrailUrl(instance.getPapertrailUrl()); 
            this.validationEnabled = validationEnabled; 
    }

    public Solarwinds build(){
            Solarwinds buildable = new Solarwinds(fluent.getAppopticsAccessToken(),fluent.getAppopticsBatchSize(),fluent.getLogs(),fluent.getMetrics(),fluent.getPapertrailLocalRetentionDuration(),fluent.getPapertrailUrl());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SolarwindsBuilder that = (SolarwindsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
