package me.snowdrop.istio.mixer.adapter.solarwinds;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Boolean;
import java.util.Map;

public interface SolarwindsFluent<A extends SolarwindsFluent<A>> extends Fluent<A>{


    public String getAppopticsAccessToken();
    public A withAppopticsAccessToken(String appopticsAccessToken);
    public Boolean hasAppopticsAccessToken();
    public A withNewAppopticsAccessToken(String arg1);
    public A withNewAppopticsAccessToken(StringBuilder arg1);
    public A withNewAppopticsAccessToken(StringBuffer arg1);
    public Integer getAppopticsBatchSize();
    public A withAppopticsBatchSize(Integer appopticsBatchSize);
    public Boolean hasAppopticsBatchSize();
    public A addToLogs(String key,me.snowdrop.istio.mixer.adapter.solarwinds.LogInfo value);
    public A addToLogs(Map<String,me.snowdrop.istio.mixer.adapter.solarwinds.LogInfo> map);
    public A removeFromLogs(String key);
    public A removeFromLogs(Map<String,me.snowdrop.istio.mixer.adapter.solarwinds.LogInfo> map);
    public Map<String,me.snowdrop.istio.mixer.adapter.solarwinds.LogInfo> getLogs();
    public A withLogs(Map<String,me.snowdrop.istio.mixer.adapter.solarwinds.LogInfo> logs);
    public Boolean hasLogs();
    public A addToMetrics(String key,me.snowdrop.istio.mixer.adapter.solarwinds.MetricInfo value);
    public A addToMetrics(Map<String,me.snowdrop.istio.mixer.adapter.solarwinds.MetricInfo> map);
    public A removeFromMetrics(String key);
    public A removeFromMetrics(Map<String,me.snowdrop.istio.mixer.adapter.solarwinds.MetricInfo> map);
    public Map<String,me.snowdrop.istio.mixer.adapter.solarwinds.MetricInfo> getMetrics();
    public A withMetrics(Map<String,me.snowdrop.istio.mixer.adapter.solarwinds.MetricInfo> metrics);
    public Boolean hasMetrics();
    public Integer getPapertrailLocalRetentionDuration();
    public A withPapertrailLocalRetentionDuration(Integer papertrailLocalRetentionDuration);
    public Boolean hasPapertrailLocalRetentionDuration();
    public String getPapertrailUrl();
    public A withPapertrailUrl(String papertrailUrl);
    public Boolean hasPapertrailUrl();
    public A withNewPapertrailUrl(String arg1);
    public A withNewPapertrailUrl(StringBuilder arg1);
    public A withNewPapertrailUrl(StringBuffer arg1);



}
