
package me.snowdrop.istio.mixer.adapter.stackdriver;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.mixer.adapter.stackdriver.Stackdriver.Creds;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "apiKey"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class ApiKeyCreds implements Serializable, Creds
{

    /**
     * 
     */
    @JsonProperty("apiKey")
    @JsonPropertyDescription("")
    private String apiKey;
    private final static long serialVersionUID = -8483336516506240197L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ApiKeyCreds() {
    }

    /**
     * 
     * @param apiKey
     */
    public ApiKeyCreds(String apiKey) {
        super();
        this.apiKey = apiKey;
    }

    /**
     * 
     */
    public String getApiKey() {
        return apiKey;
    }

    /**
     * 
     */
    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

}
