
package me.snowdrop.istio.mixer.adapter.stackdriver;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.mixer.adapter.stackdriver.Stackdriver.Creds;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "appCredentials"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class AppCredentialsCreds implements Serializable, Creds
{

    /**
     * 
     */
    @JsonProperty("appCredentials")
    @JsonPropertyDescription("")
    private Boolean appCredentials;
    private final static long serialVersionUID = 3164361331160311560L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public AppCredentialsCreds() {
    }

    /**
     * 
     * @param appCredentials
     */
    public AppCredentialsCreds(Boolean appCredentials) {
        super();
        this.appCredentials = appCredentials;
    }

    /**
     * 
     */
    public Boolean getAppCredentials() {
        return appCredentials;
    }

    /**
     * 
     */
    public void setAppCredentials(Boolean appCredentials) {
        this.appCredentials = appCredentials;
    }

}
