
package me.snowdrop.istio.mixer.adapter.stackdriver;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "latency",
    "localIp",
    "method",
    "referer",
    "remoteIp",
    "requestSize",
    "responseSize",
    "status",
    "url",
    "userAgent"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class HttpRequestMapping implements Serializable
{

    /**
     * 
     */
    @JsonProperty("latency")
    @JsonPropertyDescription("")
    private String latency;
    /**
     * 
     */
    @JsonProperty("localIp")
    @JsonPropertyDescription("")
    private String localIp;
    /**
     * 
     */
    @JsonProperty("method")
    @JsonPropertyDescription("")
    private String method;
    /**
     * 
     */
    @JsonProperty("referer")
    @JsonPropertyDescription("")
    private String referer;
    /**
     * 
     */
    @JsonProperty("remoteIp")
    @JsonPropertyDescription("")
    private String remoteIp;
    /**
     * 
     */
    @JsonProperty("requestSize")
    @JsonPropertyDescription("")
    private String requestSize;
    /**
     * 
     */
    @JsonProperty("responseSize")
    @JsonPropertyDescription("")
    private String responseSize;
    /**
     * 
     */
    @JsonProperty("status")
    @JsonPropertyDescription("")
    private String status;
    /**
     * 
     */
    @JsonProperty("url")
    @JsonPropertyDescription("")
    private String url;
    /**
     * 
     */
    @JsonProperty("userAgent")
    @JsonPropertyDescription("")
    private String userAgent;
    private final static long serialVersionUID = -5990087552140184609L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public HttpRequestMapping() {
    }

    /**
     * 
     * @param referer
     * @param remoteIp
     * @param method
     * @param latency
     * @param localIp
     * @param responseSize
     * @param userAgent
     * @param requestSize
     * @param url
     * @param status
     */
    public HttpRequestMapping(String latency, String localIp, String method, String referer, String remoteIp, String requestSize, String responseSize, String status, String url, String userAgent) {
        super();
        this.latency = latency;
        this.localIp = localIp;
        this.method = method;
        this.referer = referer;
        this.remoteIp = remoteIp;
        this.requestSize = requestSize;
        this.responseSize = responseSize;
        this.status = status;
        this.url = url;
        this.userAgent = userAgent;
    }

    /**
     * 
     */
    public String getLatency() {
        return latency;
    }

    /**
     * 
     */
    public void setLatency(String latency) {
        this.latency = latency;
    }

    /**
     * 
     */
    public String getLocalIp() {
        return localIp;
    }

    /**
     * 
     */
    public void setLocalIp(String localIp) {
        this.localIp = localIp;
    }

    /**
     * 
     */
    public String getMethod() {
        return method;
    }

    /**
     * 
     */
    public void setMethod(String method) {
        this.method = method;
    }

    /**
     * 
     */
    public String getReferer() {
        return referer;
    }

    /**
     * 
     */
    public void setReferer(String referer) {
        this.referer = referer;
    }

    /**
     * 
     */
    public String getRemoteIp() {
        return remoteIp;
    }

    /**
     * 
     */
    public void setRemoteIp(String remoteIp) {
        this.remoteIp = remoteIp;
    }

    /**
     * 
     */
    public String getRequestSize() {
        return requestSize;
    }

    /**
     * 
     */
    public void setRequestSize(String requestSize) {
        this.requestSize = requestSize;
    }

    /**
     * 
     */
    public String getResponseSize() {
        return responseSize;
    }

    /**
     * 
     */
    public void setResponseSize(String responseSize) {
        this.responseSize = responseSize;
    }

    /**
     * 
     */
    public String getStatus() {
        return status;
    }

    /**
     * 
     */
    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * 
     */
    public String getUrl() {
        return url;
    }

    /**
     * 
     */
    public void setUrl(String url) {
        this.url = url;
    }

    /**
     * 
     */
    public String getUserAgent() {
        return userAgent;
    }

    /**
     * 
     */
    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

}
