package me.snowdrop.istio.mixer.adapter.stackdriver;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class HttpRequestMappingBuilder extends HttpRequestMappingFluentImpl<HttpRequestMappingBuilder> implements VisitableBuilder<HttpRequestMapping,HttpRequestMappingBuilder>{

    HttpRequestMappingFluent<?> fluent;
    Boolean validationEnabled;

    public HttpRequestMappingBuilder(){
            this(true);
    }
    public HttpRequestMappingBuilder(Boolean validationEnabled){
            this(new HttpRequestMapping(), validationEnabled);
    }
    public HttpRequestMappingBuilder(HttpRequestMappingFluent<?> fluent){
            this(fluent, true);
    }
    public HttpRequestMappingBuilder(HttpRequestMappingFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new HttpRequestMapping(), validationEnabled);
    }
    public HttpRequestMappingBuilder(HttpRequestMappingFluent<?> fluent,HttpRequestMapping instance){
            this(fluent, instance, true);
    }
    public HttpRequestMappingBuilder(HttpRequestMappingFluent<?> fluent,HttpRequestMapping instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withLatency(instance.getLatency()); 
            fluent.withLocalIp(instance.getLocalIp()); 
            fluent.withMethod(instance.getMethod()); 
            fluent.withReferer(instance.getReferer()); 
            fluent.withRemoteIp(instance.getRemoteIp()); 
            fluent.withRequestSize(instance.getRequestSize()); 
            fluent.withResponseSize(instance.getResponseSize()); 
            fluent.withStatus(instance.getStatus()); 
            fluent.withUrl(instance.getUrl()); 
            fluent.withUserAgent(instance.getUserAgent()); 
            this.validationEnabled = validationEnabled; 
    }
    public HttpRequestMappingBuilder(HttpRequestMapping instance){
            this(instance,true);
    }
    public HttpRequestMappingBuilder(HttpRequestMapping instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withLatency(instance.getLatency()); 
            this.withLocalIp(instance.getLocalIp()); 
            this.withMethod(instance.getMethod()); 
            this.withReferer(instance.getReferer()); 
            this.withRemoteIp(instance.getRemoteIp()); 
            this.withRequestSize(instance.getRequestSize()); 
            this.withResponseSize(instance.getResponseSize()); 
            this.withStatus(instance.getStatus()); 
            this.withUrl(instance.getUrl()); 
            this.withUserAgent(instance.getUserAgent()); 
            this.validationEnabled = validationEnabled; 
    }

    public HttpRequestMapping build(){
            HttpRequestMapping buildable = new HttpRequestMapping(fluent.getLatency(),fluent.getLocalIp(),fluent.getMethod(),fluent.getReferer(),fluent.getRemoteIp(),fluent.getRequestSize(),fluent.getResponseSize(),fluent.getStatus(),fluent.getUrl(),fluent.getUserAgent());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HttpRequestMappingBuilder that = (HttpRequestMappingBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
