
package me.snowdrop.istio.mixer.adapter.stackdriver;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "buckets",
    "metricType",
    "value"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class MetricInfo implements Serializable
{

    /**
     * 
     */
    @JsonProperty("buckets")
    @JsonPropertyDescription("")
    private BucketsDefinition buckets;
    @JsonProperty("kind")
    private MetricKind kind;
    /**
     * 
     */
    @JsonProperty("metricType")
    @JsonPropertyDescription("")
    private String metricType;
    @JsonProperty("value")
    private ValueType value;
    private final static long serialVersionUID = -5135530968962156505L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public MetricInfo() {
    }

    /**
     * 
     * @param metricType
     * @param kind
     * @param buckets
     * @param value
     */
    public MetricInfo(BucketsDefinition buckets, MetricKind kind, String metricType, ValueType value) {
        super();
        this.buckets = buckets;
        this.kind = kind;
        this.metricType = metricType;
        this.value = value;
    }

    /**
     * 
     */
    public BucketsDefinition getBuckets() {
        return buckets;
    }

    /**
     * 
     */
    public void setBuckets(BucketsDefinition buckets) {
        this.buckets = buckets;
    }

    public MetricKind getKind() {
        return kind;
    }

    public void setKind(MetricKind kind) {
        this.kind = kind;
    }

    /**
     * 
     */
    public String getMetricType() {
        return metricType;
    }

    /**
     * 
     */
    public void setMetricType(String metricType) {
        this.metricType = metricType;
    }

    public ValueType getValue() {
        return value;
    }

    public void setValue(ValueType value) {
        this.value = value;
    }

}
