
package me.snowdrop.istio.mixer.adapter.stackdriver;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.mixer.adapter.stackdriver.Stackdriver.Creds;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "serviceAccountPath"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class ServiceAccountPathCreds implements Serializable, Creds
{

    /**
     * 
     */
    @JsonProperty("serviceAccountPath")
    @JsonPropertyDescription("")
    private String serviceAccountPath;
    private final static long serialVersionUID = 2059101599377867633L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ServiceAccountPathCreds() {
    }

    /**
     * 
     * @param serviceAccountPath
     */
    public ServiceAccountPathCreds(String serviceAccountPath) {
        super();
        this.serviceAccountPath = serviceAccountPath;
    }

    /**
     * 
     */
    public String getServiceAccountPath() {
        return serviceAccountPath;
    }

    /**
     * 
     */
    public void setServiceAccountPath(String serviceAccountPath) {
        this.serviceAccountPath = serviceAccountPath;
    }

}
