
package me.snowdrop.istio.mixer.adapter.stackdriver;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "UniqueWriterIdentity",
    "UpdateDestination",
    "UpdateFilter",
    "UpdateIncludeChildren",
    "destination",
    "filter",
    "id"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class SinkInfo implements Serializable
{

    /**
     * 
     */
    @JsonProperty("UniqueWriterIdentity")
    @JsonPropertyDescription("")
    private Boolean uniqueWriterIdentity;
    /**
     * 
     */
    @JsonProperty("UpdateDestination")
    @JsonPropertyDescription("")
    private Boolean updateDestination;
    /**
     * 
     */
    @JsonProperty("UpdateFilter")
    @JsonPropertyDescription("")
    private Boolean updateFilter;
    /**
     * 
     */
    @JsonProperty("UpdateIncludeChildren")
    @JsonPropertyDescription("")
    private Boolean updateIncludeChildren;
    /**
     * 
     */
    @JsonProperty("destination")
    @JsonPropertyDescription("")
    private String destination;
    /**
     * 
     */
    @JsonProperty("filter")
    @JsonPropertyDescription("")
    private String filter;
    /**
     * 
     */
    @JsonProperty("id")
    @JsonPropertyDescription("")
    private String id;
    private final static long serialVersionUID = -4170338256467215688L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public SinkInfo() {
    }

    /**
     * 
     * @param filter
     * @param updateDestination
     * @param uniqueWriterIdentity
     * @param destination
     * @param updateFilter
     * @param updateIncludeChildren
     * @param id
     */
    public SinkInfo(Boolean uniqueWriterIdentity, Boolean updateDestination, Boolean updateFilter, Boolean updateIncludeChildren, String destination, String filter, String id) {
        super();
        this.uniqueWriterIdentity = uniqueWriterIdentity;
        this.updateDestination = updateDestination;
        this.updateFilter = updateFilter;
        this.updateIncludeChildren = updateIncludeChildren;
        this.destination = destination;
        this.filter = filter;
        this.id = id;
    }

    /**
     * 
     */
    public Boolean getUniqueWriterIdentity() {
        return uniqueWriterIdentity;
    }

    /**
     * 
     */
    public void setUniqueWriterIdentity(Boolean uniqueWriterIdentity) {
        this.uniqueWriterIdentity = uniqueWriterIdentity;
    }

    /**
     * 
     */
    public Boolean getUpdateDestination() {
        return updateDestination;
    }

    /**
     * 
     */
    public void setUpdateDestination(Boolean updateDestination) {
        this.updateDestination = updateDestination;
    }

    /**
     * 
     */
    public Boolean getUpdateFilter() {
        return updateFilter;
    }

    /**
     * 
     */
    public void setUpdateFilter(Boolean updateFilter) {
        this.updateFilter = updateFilter;
    }

    /**
     * 
     */
    public Boolean getUpdateIncludeChildren() {
        return updateIncludeChildren;
    }

    /**
     * 
     */
    public void setUpdateIncludeChildren(Boolean updateIncludeChildren) {
        this.updateIncludeChildren = updateIncludeChildren;
    }

    /**
     * 
     */
    public String getDestination() {
        return destination;
    }

    /**
     * 
     */
    public void setDestination(String destination) {
        this.destination = destination;
    }

    /**
     * 
     */
    public String getFilter() {
        return filter;
    }

    /**
     * 
     */
    public void setFilter(String filter) {
        this.filter = filter;
    }

    /**
     * 
     */
    public String getId() {
        return id;
    }

    /**
     * 
     */
    public void setId(String id) {
        this.id = id;
    }

}
