
package me.snowdrop.istio.mixer.adapter.stackdriver;

import java.io.Serializable;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.internal.MixerAdapter;
import me.snowdrop.istio.api.policy.v1beta1.HandlerParams;


/**
 * 
 */
@MixerAdapter(compiledAdapter = "stackdriver")
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(using = me.snowdrop.istio.api.internal.ClassWithInterfaceFieldsDeserializer.class)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "creds",
    "endpoint",
    "logInfo",
    "meshUid",
    "metricInfo",
    "projectId",
    "pushInterval",
    "trace"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Stackdriver implements Serializable, HandlerParams
{

    @JsonProperty("creds")
    @JsonUnwrapped
    private me.snowdrop.istio.mixer.adapter.stackdriver.Stackdriver.Creds creds;
    /**
     * 
     */
    @JsonProperty("endpoint")
    @JsonPropertyDescription("")
    private java.lang.String endpoint;
    /**
     * 
     */
    @JsonProperty("logInfo")
    @JsonPropertyDescription("")
    private Map<String, LogInfo> logInfo;
    /**
     * 
     */
    @JsonProperty("meshUid")
    @JsonPropertyDescription("")
    private java.lang.String meshUid;
    /**
     * 
     */
    @JsonProperty("metricInfo")
    @JsonPropertyDescription("")
    private Map<String, MetricInfo> metricInfo;
    /**
     * 
     */
    @JsonProperty("projectId")
    @JsonPropertyDescription("")
    private java.lang.String projectId;
    /**
     * 
     */
    @JsonProperty("pushInterval")
    @JsonPropertyDescription("")
    private Integer pushInterval;
    /**
     * 
     */
    @JsonProperty("trace")
    @JsonPropertyDescription("")
    private Trace trace;
    private final static long serialVersionUID = 7660724532711308594L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Stackdriver() {
    }

    /**
     * 
     * @param endpoint
     * @param trace
     * @param meshUid
     * @param metricInfo
     * @param logInfo
     * @param pushInterval
     * @param creds
     * @param projectId
     */
    public Stackdriver(me.snowdrop.istio.mixer.adapter.stackdriver.Stackdriver.Creds creds, java.lang.String endpoint, Map<String, LogInfo> logInfo, java.lang.String meshUid, Map<String, MetricInfo> metricInfo, java.lang.String projectId, Integer pushInterval, Trace trace) {
        super();
        this.creds = creds;
        this.endpoint = endpoint;
        this.logInfo = logInfo;
        this.meshUid = meshUid;
        this.metricInfo = metricInfo;
        this.projectId = projectId;
        this.pushInterval = pushInterval;
        this.trace = trace;
    }

    public me.snowdrop.istio.mixer.adapter.stackdriver.Stackdriver.Creds getCreds() {
        return creds;
    }

    public void setCreds(me.snowdrop.istio.mixer.adapter.stackdriver.Stackdriver.Creds creds) {
        this.creds = creds;
    }

    /**
     * 
     */
    public java.lang.String getEndpoint() {
        return endpoint;
    }

    /**
     * 
     */
    public void setEndpoint(java.lang.String endpoint) {
        this.endpoint = endpoint;
    }

    /**
     * 
     */
    public Map<String, LogInfo> getLogInfo() {
        return logInfo;
    }

    /**
     * 
     */
    public void setLogInfo(Map<String, LogInfo> logInfo) {
        this.logInfo = logInfo;
    }

    /**
     * 
     */
    public java.lang.String getMeshUid() {
        return meshUid;
    }

    /**
     * 
     */
    public void setMeshUid(java.lang.String meshUid) {
        this.meshUid = meshUid;
    }

    /**
     * 
     */
    public Map<String, MetricInfo> getMetricInfo() {
        return metricInfo;
    }

    /**
     * 
     */
    public void setMetricInfo(Map<String, MetricInfo> metricInfo) {
        this.metricInfo = metricInfo;
    }

    /**
     * 
     */
    public java.lang.String getProjectId() {
        return projectId;
    }

    /**
     * 
     */
    public void setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
    }

    /**
     * 
     */
    public Integer getPushInterval() {
        return pushInterval;
    }

    /**
     * 
     */
    public void setPushInterval(Integer pushInterval) {
        this.pushInterval = pushInterval;
    }

    /**
     * 
     */
    public Trace getTrace() {
        return trace;
    }

    /**
     * 
     */
    public void setTrace(Trace trace) {
        this.trace = trace;
    }

    public interface Creds extends Serializable
    {


    }

}
