package me.snowdrop.istio.mixer.adapter.stackdriver;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class StackdriverBuilder extends StackdriverFluentImpl<StackdriverBuilder> implements VisitableBuilder<Stackdriver,StackdriverBuilder>{

    StackdriverFluent<?> fluent;
    Boolean validationEnabled;

    public StackdriverBuilder(){
            this(true);
    }
    public StackdriverBuilder(Boolean validationEnabled){
            this(new Stackdriver(), validationEnabled);
    }
    public StackdriverBuilder(StackdriverFluent<?> fluent){
            this(fluent, true);
    }
    public StackdriverBuilder(StackdriverFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Stackdriver(), validationEnabled);
    }
    public StackdriverBuilder(StackdriverFluent<?> fluent,Stackdriver instance){
            this(fluent, instance, true);
    }
    public StackdriverBuilder(StackdriverFluent<?> fluent,Stackdriver instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCreds(instance.getCreds()); 
            fluent.withEndpoint(instance.getEndpoint()); 
            fluent.withLogInfo(instance.getLogInfo()); 
            fluent.withMeshUid(instance.getMeshUid()); 
            fluent.withMetricInfo(instance.getMetricInfo()); 
            fluent.withProjectId(instance.getProjectId()); 
            fluent.withPushInterval(instance.getPushInterval()); 
            fluent.withTrace(instance.getTrace()); 
            this.validationEnabled = validationEnabled; 
    }
    public StackdriverBuilder(Stackdriver instance){
            this(instance,true);
    }
    public StackdriverBuilder(Stackdriver instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCreds(instance.getCreds()); 
            this.withEndpoint(instance.getEndpoint()); 
            this.withLogInfo(instance.getLogInfo()); 
            this.withMeshUid(instance.getMeshUid()); 
            this.withMetricInfo(instance.getMetricInfo()); 
            this.withProjectId(instance.getProjectId()); 
            this.withPushInterval(instance.getPushInterval()); 
            this.withTrace(instance.getTrace()); 
            this.validationEnabled = validationEnabled; 
    }

    public Stackdriver build(){
            Stackdriver buildable = new Stackdriver(fluent.getCreds(),fluent.getEndpoint(),fluent.getLogInfo(),fluent.getMeshUid(),fluent.getMetricInfo(),fluent.getProjectId(),fluent.getPushInterval(),fluent.getTrace());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            StackdriverBuilder that = (StackdriverBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
