package me.snowdrop.istio.mixer.adapter.stackdriver;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.lang.Boolean;
import java.lang.Double;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Object;
import java.util.Map;

public class StackdriverFluentImpl<A extends StackdriverFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements StackdriverFluent<A>{

    private VisitableBuilder<? extends Stackdriver.Creds,?> creds;
    private String endpoint;
    private Map<String,me.snowdrop.istio.mixer.adapter.stackdriver.LogInfo> logInfo;
    private String meshUid;
    private Map<String,me.snowdrop.istio.mixer.adapter.stackdriver.MetricInfo> metricInfo;
    private String projectId;
    private Integer pushInterval;
    private TraceBuilder trace;

    public StackdriverFluentImpl(){
    }
    public StackdriverFluentImpl(Stackdriver instance){
            this.withCreds(instance.getCreds()); 
            this.withEndpoint(instance.getEndpoint()); 
            this.withLogInfo(instance.getLogInfo()); 
            this.withMeshUid(instance.getMeshUid()); 
            this.withMetricInfo(instance.getMetricInfo()); 
            this.withProjectId(instance.getProjectId()); 
            this.withPushInterval(instance.getPushInterval()); 
            this.withTrace(instance.getTrace()); 
    }

    
/**
 * This method has been deprecated, please use method buildCreds instead.
 * @return The buildable object.
 */
@Deprecated public Stackdriver.Creds getCreds(){
            return this.creds!=null?this.creds.build():null;
    }

    public Stackdriver.Creds buildCreds(){
            return this.creds!=null?this.creds.build():null;
    }

    public A withCreds(Stackdriver.Creds creds){
            if (creds instanceof ApiKeyCreds){ this.creds= new ApiKeyCredsBuilder((ApiKeyCreds)creds); _visitables.get("creds").add(this.creds);}
            if (creds instanceof AppCredentialsCreds){ this.creds= new AppCredentialsCredsBuilder((AppCredentialsCreds)creds); _visitables.get("creds").add(this.creds);}
            if (creds instanceof ServiceAccountPathCreds){ this.creds= new ServiceAccountPathCredsBuilder((ServiceAccountPathCreds)creds); _visitables.get("creds").add(this.creds);}
            return (A) this;
    }

    public Boolean hasCreds(){
            return this.creds != null;
    }

    public A withApiKeyCreds(ApiKeyCreds apiKeyCreds){
            _visitables.get("creds").remove(this.creds);
            if (apiKeyCreds!=null){ this.creds= new ApiKeyCredsBuilder(apiKeyCreds); _visitables.get("creds").add(this.creds);} return (A) this;
    }

    public StackdriverFluent.ApiKeyCredsNested<A> withNewApiKeyCreds(){
            return new ApiKeyCredsNestedImpl();
    }

    public StackdriverFluent.ApiKeyCredsNested<A> withNewApiKeyCredsLike(ApiKeyCreds item){
            return new ApiKeyCredsNestedImpl(item);
    }

    public A withNewApiKeyCreds(String apiKey){
            return (A)withApiKeyCreds(new ApiKeyCreds(apiKey));
    }

    public A withAppCredentialsCreds(AppCredentialsCreds appCredentialsCreds){
            _visitables.get("creds").remove(this.creds);
            if (appCredentialsCreds!=null){ this.creds= new AppCredentialsCredsBuilder(appCredentialsCreds); _visitables.get("creds").add(this.creds);} return (A) this;
    }

    public StackdriverFluent.AppCredentialsCredsNested<A> withNewAppCredentialsCreds(){
            return new AppCredentialsCredsNestedImpl();
    }

    public StackdriverFluent.AppCredentialsCredsNested<A> withNewAppCredentialsCredsLike(AppCredentialsCreds item){
            return new AppCredentialsCredsNestedImpl(item);
    }

    public A withNewAppCredentialsCreds(Boolean appCredentials){
            return (A)withAppCredentialsCreds(new AppCredentialsCreds(appCredentials));
    }

    public A withServiceAccountPathCreds(ServiceAccountPathCreds serviceAccountPathCreds){
            _visitables.get("creds").remove(this.creds);
            if (serviceAccountPathCreds!=null){ this.creds= new ServiceAccountPathCredsBuilder(serviceAccountPathCreds); _visitables.get("creds").add(this.creds);} return (A) this;
    }

    public StackdriverFluent.ServiceAccountPathCredsNested<A> withNewServiceAccountPathCreds(){
            return new ServiceAccountPathCredsNestedImpl();
    }

    public StackdriverFluent.ServiceAccountPathCredsNested<A> withNewServiceAccountPathCredsLike(ServiceAccountPathCreds item){
            return new ServiceAccountPathCredsNestedImpl(item);
    }

    public A withNewServiceAccountPathCreds(String serviceAccountPath){
            return (A)withServiceAccountPathCreds(new ServiceAccountPathCreds(serviceAccountPath));
    }

    public String getEndpoint(){
            return this.endpoint;
    }

    public A withEndpoint(String endpoint){
            this.endpoint=endpoint; return (A) this;
    }

    public Boolean hasEndpoint(){
            return this.endpoint != null;
    }

    public A withNewEndpoint(String arg1){
            return (A)withEndpoint(new String(arg1));
    }

    public A withNewEndpoint(StringBuilder arg1){
            return (A)withEndpoint(new String(arg1));
    }

    public A withNewEndpoint(StringBuffer arg1){
            return (A)withEndpoint(new String(arg1));
    }

    public A addToLogInfo(String key,me.snowdrop.istio.mixer.adapter.stackdriver.LogInfo value){
            if(this.logInfo == null && key != null && value != null) { this.logInfo = new LinkedHashMap<String,me.snowdrop.istio.mixer.adapter.stackdriver.LogInfo>(); }
            if(key != null && value != null) {this.logInfo.put(key, value);} return (A)this;
    }

    public A addToLogInfo(Map<String,me.snowdrop.istio.mixer.adapter.stackdriver.LogInfo> map){
            if(this.logInfo == null && map != null) { this.logInfo = new LinkedHashMap<String,me.snowdrop.istio.mixer.adapter.stackdriver.LogInfo>(); }
            if(map != null) { this.logInfo.putAll(map);} return (A)this;
    }

    public A removeFromLogInfo(String key){
            if(this.logInfo == null) { return (A) this; }
            if(key != null && this.logInfo != null) {this.logInfo.remove(key);} return (A)this;
    }

    public A removeFromLogInfo(Map<String,me.snowdrop.istio.mixer.adapter.stackdriver.LogInfo> map){
            if(this.logInfo == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.logInfo != null){this.logInfo.remove(key);}}} return (A)this;
    }

    public Map<String,me.snowdrop.istio.mixer.adapter.stackdriver.LogInfo> getLogInfo(){
            return this.logInfo;
    }

    public A withLogInfo(Map<String,me.snowdrop.istio.mixer.adapter.stackdriver.LogInfo> logInfo){
            if (logInfo == null) { this.logInfo =  null;} else {this.logInfo = new LinkedHashMap<String,me.snowdrop.istio.mixer.adapter.stackdriver.LogInfo>(logInfo);} return (A) this;
    }

    public Boolean hasLogInfo(){
            return this.logInfo != null;
    }

    public String getMeshUid(){
            return this.meshUid;
    }

    public A withMeshUid(String meshUid){
            this.meshUid=meshUid; return (A) this;
    }

    public Boolean hasMeshUid(){
            return this.meshUid != null;
    }

    public A withNewMeshUid(String arg1){
            return (A)withMeshUid(new String(arg1));
    }

    public A withNewMeshUid(StringBuilder arg1){
            return (A)withMeshUid(new String(arg1));
    }

    public A withNewMeshUid(StringBuffer arg1){
            return (A)withMeshUid(new String(arg1));
    }

    public A addToMetricInfo(String key,me.snowdrop.istio.mixer.adapter.stackdriver.MetricInfo value){
            if(this.metricInfo == null && key != null && value != null) { this.metricInfo = new LinkedHashMap<String,me.snowdrop.istio.mixer.adapter.stackdriver.MetricInfo>(); }
            if(key != null && value != null) {this.metricInfo.put(key, value);} return (A)this;
    }

    public A addToMetricInfo(Map<String,me.snowdrop.istio.mixer.adapter.stackdriver.MetricInfo> map){
            if(this.metricInfo == null && map != null) { this.metricInfo = new LinkedHashMap<String,me.snowdrop.istio.mixer.adapter.stackdriver.MetricInfo>(); }
            if(map != null) { this.metricInfo.putAll(map);} return (A)this;
    }

    public A removeFromMetricInfo(String key){
            if(this.metricInfo == null) { return (A) this; }
            if(key != null && this.metricInfo != null) {this.metricInfo.remove(key);} return (A)this;
    }

    public A removeFromMetricInfo(Map<String,me.snowdrop.istio.mixer.adapter.stackdriver.MetricInfo> map){
            if(this.metricInfo == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.metricInfo != null){this.metricInfo.remove(key);}}} return (A)this;
    }

    public Map<String,me.snowdrop.istio.mixer.adapter.stackdriver.MetricInfo> getMetricInfo(){
            return this.metricInfo;
    }

    public A withMetricInfo(Map<String,me.snowdrop.istio.mixer.adapter.stackdriver.MetricInfo> metricInfo){
            if (metricInfo == null) { this.metricInfo =  null;} else {this.metricInfo = new LinkedHashMap<String,me.snowdrop.istio.mixer.adapter.stackdriver.MetricInfo>(metricInfo);} return (A) this;
    }

    public Boolean hasMetricInfo(){
            return this.metricInfo != null;
    }

    public String getProjectId(){
            return this.projectId;
    }

    public A withProjectId(String projectId){
            this.projectId=projectId; return (A) this;
    }

    public Boolean hasProjectId(){
            return this.projectId != null;
    }

    public A withNewProjectId(String arg1){
            return (A)withProjectId(new String(arg1));
    }

    public A withNewProjectId(StringBuilder arg1){
            return (A)withProjectId(new String(arg1));
    }

    public A withNewProjectId(StringBuffer arg1){
            return (A)withProjectId(new String(arg1));
    }

    public Integer getPushInterval(){
            return this.pushInterval;
    }

    public A withPushInterval(Integer pushInterval){
            this.pushInterval=pushInterval; return (A) this;
    }

    public Boolean hasPushInterval(){
            return this.pushInterval != null;
    }

    
/**
 * This method has been deprecated, please use method buildTrace instead.
 * @return The buildable object.
 */
@Deprecated public Trace getTrace(){
            return this.trace!=null?this.trace.build():null;
    }

    public Trace buildTrace(){
            return this.trace!=null?this.trace.build():null;
    }

    public A withTrace(Trace trace){
            _visitables.get("trace").remove(this.trace);
            if (trace!=null){ this.trace= new TraceBuilder(trace); _visitables.get("trace").add(this.trace);} return (A) this;
    }

    public Boolean hasTrace(){
            return this.trace != null;
    }

    public A withNewTrace(Double sampleProbability){
            return (A)withTrace(new Trace(sampleProbability));
    }

    public StackdriverFluent.TraceNested<A> withNewTrace(){
            return new TraceNestedImpl();
    }

    public StackdriverFluent.TraceNested<A> withNewTraceLike(Trace item){
            return new TraceNestedImpl(item);
    }

    public StackdriverFluent.TraceNested<A> editTrace(){
            return withNewTraceLike(getTrace());
    }

    public StackdriverFluent.TraceNested<A> editOrNewTrace(){
            return withNewTraceLike(getTrace() != null ? getTrace(): new TraceBuilder().build());
    }

    public StackdriverFluent.TraceNested<A> editOrNewTraceLike(Trace item){
            return withNewTraceLike(getTrace() != null ? getTrace(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            StackdriverFluentImpl that = (StackdriverFluentImpl) o;
            if (creds != null ? !creds.equals(that.creds) :that.creds != null) return false;
            if (endpoint != null ? !endpoint.equals(that.endpoint) :that.endpoint != null) return false;
            if (logInfo != null ? !logInfo.equals(that.logInfo) :that.logInfo != null) return false;
            if (meshUid != null ? !meshUid.equals(that.meshUid) :that.meshUid != null) return false;
            if (metricInfo != null ? !metricInfo.equals(that.metricInfo) :that.metricInfo != null) return false;
            if (projectId != null ? !projectId.equals(that.projectId) :that.projectId != null) return false;
            if (pushInterval != null ? !pushInterval.equals(that.pushInterval) :that.pushInterval != null) return false;
            if (trace != null ? !trace.equals(that.trace) :that.trace != null) return false;
            return true;
    }


    public class ApiKeyCredsNestedImpl<N> extends ApiKeyCredsFluentImpl<StackdriverFluent.ApiKeyCredsNested<N>> implements StackdriverFluent.ApiKeyCredsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ApiKeyCredsBuilder builder;
    
            ApiKeyCredsNestedImpl(ApiKeyCreds item){
                    this.builder = new ApiKeyCredsBuilder(this, item);
            }
            ApiKeyCredsNestedImpl(){
                    this.builder = new ApiKeyCredsBuilder(this);
            }
    
    public N and(){
            return (N) StackdriverFluentImpl.this.withCreds(builder.build());
    }
    public N endApiKeyCreds(){
            return and();
    }

}
    public class AppCredentialsCredsNestedImpl<N> extends AppCredentialsCredsFluentImpl<StackdriverFluent.AppCredentialsCredsNested<N>> implements StackdriverFluent.AppCredentialsCredsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final AppCredentialsCredsBuilder builder;
    
            AppCredentialsCredsNestedImpl(AppCredentialsCreds item){
                    this.builder = new AppCredentialsCredsBuilder(this, item);
            }
            AppCredentialsCredsNestedImpl(){
                    this.builder = new AppCredentialsCredsBuilder(this);
            }
    
    public N and(){
            return (N) StackdriverFluentImpl.this.withCreds(builder.build());
    }
    public N endAppCredentialsCreds(){
            return and();
    }

}
    public class ServiceAccountPathCredsNestedImpl<N> extends ServiceAccountPathCredsFluentImpl<StackdriverFluent.ServiceAccountPathCredsNested<N>> implements StackdriverFluent.ServiceAccountPathCredsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ServiceAccountPathCredsBuilder builder;
    
            ServiceAccountPathCredsNestedImpl(ServiceAccountPathCreds item){
                    this.builder = new ServiceAccountPathCredsBuilder(this, item);
            }
            ServiceAccountPathCredsNestedImpl(){
                    this.builder = new ServiceAccountPathCredsBuilder(this);
            }
    
    public N and(){
            return (N) StackdriverFluentImpl.this.withCreds(builder.build());
    }
    public N endServiceAccountPathCreds(){
            return and();
    }

}
    public class TraceNestedImpl<N> extends TraceFluentImpl<StackdriverFluent.TraceNested<N>> implements StackdriverFluent.TraceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TraceBuilder builder;
    
            TraceNestedImpl(Trace item){
                    this.builder = new TraceBuilder(this, item);
            }
            TraceNestedImpl(){
                    this.builder = new TraceBuilder(this);
            }
    
    public N and(){
            return (N) StackdriverFluentImpl.this.withTrace(builder.build());
    }
    public N endTrace(){
            return and();
    }

}


}
