
package me.snowdrop.istio.mixer.adapter.stackdriver;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "sampleProbability"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Trace implements Serializable
{

    /**
     * 
     */
    @JsonProperty("sampleProbability")
    @JsonPropertyDescription("")
    private Double sampleProbability;
    private final static long serialVersionUID = 6471927446304110809L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Trace() {
    }

    /**
     * 
     * @param sampleProbability
     */
    public Trace(Double sampleProbability) {
        super();
        this.sampleProbability = sampleProbability;
    }

    /**
     * 
     */
    public Double getSampleProbability() {
        return sampleProbability;
    }

    /**
     * 
     */
    public void setSampleProbability(Double sampleProbability) {
        this.sampleProbability = sampleProbability;
    }

}
