package me.snowdrop.istio.mixer.adapter.stackdriver;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TraceBuilder extends TraceFluentImpl<TraceBuilder> implements VisitableBuilder<Trace,TraceBuilder>{

    TraceFluent<?> fluent;
    Boolean validationEnabled;

    public TraceBuilder(){
            this(true);
    }
    public TraceBuilder(Boolean validationEnabled){
            this(new Trace(), validationEnabled);
    }
    public TraceBuilder(TraceFluent<?> fluent){
            this(fluent, true);
    }
    public TraceBuilder(TraceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Trace(), validationEnabled);
    }
    public TraceBuilder(TraceFluent<?> fluent,Trace instance){
            this(fluent, instance, true);
    }
    public TraceBuilder(TraceFluent<?> fluent,Trace instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withSampleProbability(instance.getSampleProbability()); 
            this.validationEnabled = validationEnabled; 
    }
    public TraceBuilder(Trace instance){
            this(instance,true);
    }
    public TraceBuilder(Trace instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withSampleProbability(instance.getSampleProbability()); 
            this.validationEnabled = validationEnabled; 
    }

    public Trace build(){
            Trace buildable = new Trace(fluent.getSampleProbability());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TraceBuilder that = (TraceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
