
package me.snowdrop.istio.mixer.adapter.statsd;

import java.io.Serializable;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.internal.MixerAdapter;
import me.snowdrop.istio.api.policy.v1beta1.HandlerParams;


/**
 * 
 */
@MixerAdapter(compiledAdapter = "statsd")
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "address",
    "flushBytes",
    "flushDuration",
    "metrics",
    "prefix",
    "samplingRate"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Statsd implements Serializable, HandlerParams
{

    /**
     * 
     */
    @JsonProperty("address")
    @JsonPropertyDescription("")
    private java.lang.String address;
    /**
     * 
     */
    @JsonProperty("flushBytes")
    @JsonPropertyDescription("")
    private Integer flushBytes;
    /**
     * 
     */
    @JsonProperty("flushDuration")
    @JsonPropertyDescription("")
    private Integer flushDuration;
    /**
     * 
     */
    @JsonProperty("metrics")
    @JsonPropertyDescription("")
    private Map<String, MetricInfo> metrics;
    /**
     * 
     */
    @JsonProperty("prefix")
    @JsonPropertyDescription("")
    private java.lang.String prefix;
    /**
     * 
     */
    @JsonProperty("samplingRate")
    @JsonPropertyDescription("")
    private Double samplingRate;
    private final static long serialVersionUID = -1080577490039469466L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Statsd() {
    }

    /**
     * 
     * @param address
     * @param prefix
     * @param samplingRate
     * @param metrics
     * @param flushBytes
     * @param flushDuration
     */
    public Statsd(java.lang.String address, Integer flushBytes, Integer flushDuration, Map<String, MetricInfo> metrics, java.lang.String prefix, Double samplingRate) {
        super();
        this.address = address;
        this.flushBytes = flushBytes;
        this.flushDuration = flushDuration;
        this.metrics = metrics;
        this.prefix = prefix;
        this.samplingRate = samplingRate;
    }

    /**
     * 
     */
    public java.lang.String getAddress() {
        return address;
    }

    /**
     * 
     */
    public void setAddress(java.lang.String address) {
        this.address = address;
    }

    /**
     * 
     */
    public Integer getFlushBytes() {
        return flushBytes;
    }

    /**
     * 
     */
    public void setFlushBytes(Integer flushBytes) {
        this.flushBytes = flushBytes;
    }

    /**
     * 
     */
    public Integer getFlushDuration() {
        return flushDuration;
    }

    /**
     * 
     */
    public void setFlushDuration(Integer flushDuration) {
        this.flushDuration = flushDuration;
    }

    /**
     * 
     */
    public Map<String, MetricInfo> getMetrics() {
        return metrics;
    }

    /**
     * 
     */
    public void setMetrics(Map<String, MetricInfo> metrics) {
        this.metrics = metrics;
    }

    /**
     * 
     */
    public java.lang.String getPrefix() {
        return prefix;
    }

    /**
     * 
     */
    public void setPrefix(java.lang.String prefix) {
        this.prefix = prefix;
    }

    /**
     * 
     */
    public Double getSamplingRate() {
        return samplingRate;
    }

    /**
     * 
     */
    public void setSamplingRate(Double samplingRate) {
        this.samplingRate = samplingRate;
    }

}
