package me.snowdrop.istio.mixer.adapter.statsd;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.lang.String;
import java.lang.Double;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public class StatsdFluentImpl<A extends StatsdFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements StatsdFluent<A>{

    private String address;
    private Integer flushBytes;
    private Integer flushDuration;
    private Map<String,me.snowdrop.istio.mixer.adapter.statsd.MetricInfo> metrics;
    private String prefix;
    private Double samplingRate;

    public StatsdFluentImpl(){
    }
    public StatsdFluentImpl(Statsd instance){
            this.withAddress(instance.getAddress()); 
            this.withFlushBytes(instance.getFlushBytes()); 
            this.withFlushDuration(instance.getFlushDuration()); 
            this.withMetrics(instance.getMetrics()); 
            this.withPrefix(instance.getPrefix()); 
            this.withSamplingRate(instance.getSamplingRate()); 
    }

    public String getAddress(){
            return this.address;
    }

    public A withAddress(String address){
            this.address=address; return (A) this;
    }

    public Boolean hasAddress(){
            return this.address != null;
    }

    public A withNewAddress(String arg1){
            return (A)withAddress(new String(arg1));
    }

    public A withNewAddress(StringBuilder arg1){
            return (A)withAddress(new String(arg1));
    }

    public A withNewAddress(StringBuffer arg1){
            return (A)withAddress(new String(arg1));
    }

    public Integer getFlushBytes(){
            return this.flushBytes;
    }

    public A withFlushBytes(Integer flushBytes){
            this.flushBytes=flushBytes; return (A) this;
    }

    public Boolean hasFlushBytes(){
            return this.flushBytes != null;
    }

    public Integer getFlushDuration(){
            return this.flushDuration;
    }

    public A withFlushDuration(Integer flushDuration){
            this.flushDuration=flushDuration; return (A) this;
    }

    public Boolean hasFlushDuration(){
            return this.flushDuration != null;
    }

    public A addToMetrics(String key,me.snowdrop.istio.mixer.adapter.statsd.MetricInfo value){
            if(this.metrics == null && key != null && value != null) { this.metrics = new LinkedHashMap<String,me.snowdrop.istio.mixer.adapter.statsd.MetricInfo>(); }
            if(key != null && value != null) {this.metrics.put(key, value);} return (A)this;
    }

    public A addToMetrics(Map<String,me.snowdrop.istio.mixer.adapter.statsd.MetricInfo> map){
            if(this.metrics == null && map != null) { this.metrics = new LinkedHashMap<String,me.snowdrop.istio.mixer.adapter.statsd.MetricInfo>(); }
            if(map != null) { this.metrics.putAll(map);} return (A)this;
    }

    public A removeFromMetrics(String key){
            if(this.metrics == null) { return (A) this; }
            if(key != null && this.metrics != null) {this.metrics.remove(key);} return (A)this;
    }

    public A removeFromMetrics(Map<String,me.snowdrop.istio.mixer.adapter.statsd.MetricInfo> map){
            if(this.metrics == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.metrics != null){this.metrics.remove(key);}}} return (A)this;
    }

    public Map<String,me.snowdrop.istio.mixer.adapter.statsd.MetricInfo> getMetrics(){
            return this.metrics;
    }

    public A withMetrics(Map<String,me.snowdrop.istio.mixer.adapter.statsd.MetricInfo> metrics){
            if (metrics == null) { this.metrics =  null;} else {this.metrics = new LinkedHashMap<String,me.snowdrop.istio.mixer.adapter.statsd.MetricInfo>(metrics);} return (A) this;
    }

    public Boolean hasMetrics(){
            return this.metrics != null;
    }

    public String getPrefix(){
            return this.prefix;
    }

    public A withPrefix(String prefix){
            this.prefix=prefix; return (A) this;
    }

    public Boolean hasPrefix(){
            return this.prefix != null;
    }

    public A withNewPrefix(String arg1){
            return (A)withPrefix(new String(arg1));
    }

    public A withNewPrefix(StringBuilder arg1){
            return (A)withPrefix(new String(arg1));
    }

    public A withNewPrefix(StringBuffer arg1){
            return (A)withPrefix(new String(arg1));
    }

    public Double getSamplingRate(){
            return this.samplingRate;
    }

    public A withSamplingRate(Double samplingRate){
            this.samplingRate=samplingRate; return (A) this;
    }

    public Boolean hasSamplingRate(){
            return this.samplingRate != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            StatsdFluentImpl that = (StatsdFluentImpl) o;
            if (address != null ? !address.equals(that.address) :that.address != null) return false;
            if (flushBytes != null ? !flushBytes.equals(that.flushBytes) :that.flushBytes != null) return false;
            if (flushDuration != null ? !flushDuration.equals(that.flushDuration) :that.flushDuration != null) return false;
            if (metrics != null ? !metrics.equals(that.metrics) :that.metrics != null) return false;
            if (prefix != null ? !prefix.equals(that.prefix) :that.prefix != null) return false;
            if (samplingRate != null ? !samplingRate.equals(that.samplingRate) :that.samplingRate != null) return false;
            return true;
    }




}
