
package me.snowdrop.istio.mixer.adapter.stdio;

import java.io.Serializable;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.internal.MixerAdapter;
import me.snowdrop.istio.api.policy.v1beta1.HandlerParams;


/**
 * 
 */
@MixerAdapter(compiledAdapter = "stdio")
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "logStream",
    "maxDaysBeforeRotation",
    "maxMegabytesBeforeRotation",
    "maxRotatedFiles",
    "metricLevel",
    "outputAsJson",
    "outputLevel",
    "outputPath",
    "severityLevels"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Stdio implements Serializable, HandlerParams
{

    @JsonProperty("logStream")
    private Stream logStream;
    /**
     * 
     */
    @JsonProperty("maxDaysBeforeRotation")
    @JsonPropertyDescription("")
    private java.lang.Integer maxDaysBeforeRotation;
    /**
     * 
     */
    @JsonProperty("maxMegabytesBeforeRotation")
    @JsonPropertyDescription("")
    private java.lang.Integer maxMegabytesBeforeRotation;
    /**
     * 
     */
    @JsonProperty("maxRotatedFiles")
    @JsonPropertyDescription("")
    private java.lang.Integer maxRotatedFiles;
    @JsonProperty("metricLevel")
    private me.snowdrop.istio.mixer.adapter.stdio.Level metricLevel;
    /**
     * 
     */
    @JsonProperty("outputAsJson")
    @JsonPropertyDescription("")
    private Boolean outputAsJson;
    @JsonProperty("outputLevel")
    private me.snowdrop.istio.mixer.adapter.stdio.Level outputLevel;
    /**
     * 
     */
    @JsonProperty("outputPath")
    @JsonPropertyDescription("")
    private java.lang.String outputPath;
    /**
     * 
     */
    @JsonProperty("severityLevels")
    @JsonPropertyDescription("")
    private Map<String, Integer> severityLevels;
    private final static long serialVersionUID = -4632843247620110059L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Stdio() {
    }

    /**
     * 
     * @param maxDaysBeforeRotation
     * @param maxMegabytesBeforeRotation
     * @param maxRotatedFiles
     * @param outputPath
     * @param outputAsJson
     * @param logStream
     * @param outputLevel
     * @param metricLevel
     * @param severityLevels
     */
    public Stdio(Stream logStream, java.lang.Integer maxDaysBeforeRotation, java.lang.Integer maxMegabytesBeforeRotation, java.lang.Integer maxRotatedFiles, me.snowdrop.istio.mixer.adapter.stdio.Level metricLevel, Boolean outputAsJson, me.snowdrop.istio.mixer.adapter.stdio.Level outputLevel, java.lang.String outputPath, Map<String, Integer> severityLevels) {
        super();
        this.logStream = logStream;
        this.maxDaysBeforeRotation = maxDaysBeforeRotation;
        this.maxMegabytesBeforeRotation = maxMegabytesBeforeRotation;
        this.maxRotatedFiles = maxRotatedFiles;
        this.metricLevel = metricLevel;
        this.outputAsJson = outputAsJson;
        this.outputLevel = outputLevel;
        this.outputPath = outputPath;
        this.severityLevels = severityLevels;
    }

    public Stream getLogStream() {
        return logStream;
    }

    public void setLogStream(Stream logStream) {
        this.logStream = logStream;
    }

    /**
     * 
     */
    public java.lang.Integer getMaxDaysBeforeRotation() {
        return maxDaysBeforeRotation;
    }

    /**
     * 
     */
    public void setMaxDaysBeforeRotation(java.lang.Integer maxDaysBeforeRotation) {
        this.maxDaysBeforeRotation = maxDaysBeforeRotation;
    }

    /**
     * 
     */
    public java.lang.Integer getMaxMegabytesBeforeRotation() {
        return maxMegabytesBeforeRotation;
    }

    /**
     * 
     */
    public void setMaxMegabytesBeforeRotation(java.lang.Integer maxMegabytesBeforeRotation) {
        this.maxMegabytesBeforeRotation = maxMegabytesBeforeRotation;
    }

    /**
     * 
     */
    public java.lang.Integer getMaxRotatedFiles() {
        return maxRotatedFiles;
    }

    /**
     * 
     */
    public void setMaxRotatedFiles(java.lang.Integer maxRotatedFiles) {
        this.maxRotatedFiles = maxRotatedFiles;
    }

    public me.snowdrop.istio.mixer.adapter.stdio.Level getMetricLevel() {
        return metricLevel;
    }

    public void setMetricLevel(me.snowdrop.istio.mixer.adapter.stdio.Level metricLevel) {
        this.metricLevel = metricLevel;
    }

    /**
     * 
     */
    public Boolean getOutputAsJson() {
        return outputAsJson;
    }

    /**
     * 
     */
    public void setOutputAsJson(Boolean outputAsJson) {
        this.outputAsJson = outputAsJson;
    }

    public me.snowdrop.istio.mixer.adapter.stdio.Level getOutputLevel() {
        return outputLevel;
    }

    public void setOutputLevel(me.snowdrop.istio.mixer.adapter.stdio.Level outputLevel) {
        this.outputLevel = outputLevel;
    }

    /**
     * 
     */
    public java.lang.String getOutputPath() {
        return outputPath;
    }

    /**
     * 
     */
    public void setOutputPath(java.lang.String outputPath) {
        this.outputPath = outputPath;
    }

    /**
     * 
     */
    public Map<String, Integer> getSeverityLevels() {
        return severityLevels;
    }

    /**
     * 
     */
    public void setSeverityLevels(Map<String, Integer> severityLevels) {
        this.severityLevels = severityLevels;
    }

}
