
package me.snowdrop.istio.mixer.adapter.zipkin;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.internal.MixerAdapter;
import me.snowdrop.istio.api.policy.v1beta1.HandlerParams;


/**
 * 
 */
@MixerAdapter(compiledAdapter = "zipkin")
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "sampleProbability",
    "url"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Zipkin implements Serializable, HandlerParams
{

    /**
     * 
     */
    @JsonProperty("sampleProbability")
    @JsonPropertyDescription("")
    private Double sampleProbability;
    /**
     * 
     */
    @JsonProperty("url")
    @JsonPropertyDescription("")
    private String url;
    private final static long serialVersionUID = 6977301706505208368L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Zipkin() {
    }

    /**
     * 
     * @param sampleProbability
     * @param url
     */
    public Zipkin(Double sampleProbability, String url) {
        super();
        this.sampleProbability = sampleProbability;
        this.url = url;
    }

    /**
     * 
     */
    public Double getSampleProbability() {
        return sampleProbability;
    }

    /**
     * 
     */
    public void setSampleProbability(Double sampleProbability) {
        this.sampleProbability = sampleProbability;
    }

    /**
     * 
     */
    public String getUrl() {
        return url;
    }

    /**
     * 
     */
    public void setUrl(String url) {
        this.url = url;
    }

}
