package me.snowdrop.istio.mixer.adapter.zipkin;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ZipkinBuilder extends ZipkinFluentImpl<ZipkinBuilder> implements VisitableBuilder<Zipkin,ZipkinBuilder>{

    ZipkinFluent<?> fluent;
    Boolean validationEnabled;

    public ZipkinBuilder(){
            this(true);
    }
    public ZipkinBuilder(Boolean validationEnabled){
            this(new Zipkin(), validationEnabled);
    }
    public ZipkinBuilder(ZipkinFluent<?> fluent){
            this(fluent, true);
    }
    public ZipkinBuilder(ZipkinFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Zipkin(), validationEnabled);
    }
    public ZipkinBuilder(ZipkinFluent<?> fluent,Zipkin instance){
            this(fluent, instance, true);
    }
    public ZipkinBuilder(ZipkinFluent<?> fluent,Zipkin instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withSampleProbability(instance.getSampleProbability()); 
            fluent.withUrl(instance.getUrl()); 
            this.validationEnabled = validationEnabled; 
    }
    public ZipkinBuilder(Zipkin instance){
            this(instance,true);
    }
    public ZipkinBuilder(Zipkin instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withSampleProbability(instance.getSampleProbability()); 
            this.withUrl(instance.getUrl()); 
            this.validationEnabled = validationEnabled; 
    }

    public Zipkin build(){
            Zipkin buildable = new Zipkin(fluent.getSampleProbability(),fluent.getUrl());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ZipkinBuilder that = (ZipkinBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
