
package me.snowdrop.istio.mixer.template.apikey;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.TimeStamp;
import me.snowdrop.istio.api.internal.MixerTemplate;
import me.snowdrop.istio.api.policy.v1beta1.InstanceParams;


/**
 * 
 */
@MixerTemplate(compiledTemplate = "apikey")
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "api",
    "apiKey",
    "apiOperation",
    "name",
    "timestamp"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class ApiKey implements Serializable, InstanceParams
{

    /**
     * 
     */
    @JsonProperty("api")
    @JsonPropertyDescription("")
    private String api;
    /**
     * 
     */
    @JsonProperty("apiKey")
    @JsonPropertyDescription("")
    private String apiKey;
    /**
     * 
     */
    @JsonProperty("apiOperation")
    @JsonPropertyDescription("")
    private String apiOperation;
    /**
     * 
     */
    @JsonProperty("apiVersion")
    @JsonPropertyDescription("")
    private String apiVersion;
    /**
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("")
    private String name;
    /**
     * 
     */
    @JsonProperty("timestamp")
    @JsonPropertyDescription("")
    private TimeStamp timestamp;
    private final static long serialVersionUID = -928475096579271552L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ApiKey() {
    }

    /**
     * 
     * @param apiVersion
     * @param apiKey
     * @param apiOperation
     * @param name
     * @param api
     * @param timestamp
     */
    public ApiKey(String api, String apiKey, String apiOperation, String apiVersion, String name, TimeStamp timestamp) {
        super();
        this.api = api;
        this.apiKey = apiKey;
        this.apiOperation = apiOperation;
        this.apiVersion = apiVersion;
        this.name = name;
        this.timestamp = timestamp;
    }

    /**
     * 
     */
    public String getApi() {
        return api;
    }

    /**
     * 
     */
    public void setApi(String api) {
        this.api = api;
    }

    /**
     * 
     */
    public String getApiKey() {
        return apiKey;
    }

    /**
     * 
     */
    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    /**
     * 
     */
    public String getApiOperation() {
        return apiOperation;
    }

    /**
     * 
     */
    public void setApiOperation(String apiOperation) {
        this.apiOperation = apiOperation;
    }

    /**
     * 
     */
    public String getApiVersion() {
        return apiVersion;
    }

    /**
     * 
     */
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    /**
     * 
     */
    public String getName() {
        return name;
    }

    /**
     * 
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 
     */
    public TimeStamp getTimestamp() {
        return timestamp;
    }

    /**
     * 
     */
    public void setTimestamp(TimeStamp timestamp) {
        this.timestamp = timestamp;
    }

}
