package me.snowdrop.istio.mixer.template.apikey;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import me.snowdrop.istio.api.TimeStampBuilder;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.lang.Deprecated;
import me.snowdrop.istio.api.TimeStampFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import com.fasterxml.jackson.core.JsonParser;
import me.snowdrop.istio.api.TimeStamp;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Long;
import java.lang.Object;

public class ApiKeyFluentImpl<A extends ApiKeyFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ApiKeyFluent<A>{

    private String api;
    private String apiKey;
    private String apiOperation;
    private String apiVersion;
    private String name;
    private TimeStampBuilder timestamp;

    public ApiKeyFluentImpl(){
    }
    public ApiKeyFluentImpl(ApiKey instance){
            this.withApi(instance.getApi()); 
            this.withApiKey(instance.getApiKey()); 
            this.withApiOperation(instance.getApiOperation()); 
            this.withApiVersion(instance.getApiVersion()); 
            this.withName(instance.getName()); 
            this.withTimestamp(instance.getTimestamp()); 
    }

    public String getApi(){
            return this.api;
    }

    public A withApi(String api){
            this.api=api; return (A) this;
    }

    public Boolean hasApi(){
            return this.api != null;
    }

    public A withNewApi(String arg1){
            return (A)withApi(new String(arg1));
    }

    public A withNewApi(StringBuilder arg1){
            return (A)withApi(new String(arg1));
    }

    public A withNewApi(StringBuffer arg1){
            return (A)withApi(new String(arg1));
    }

    public String getApiKey(){
            return this.apiKey;
    }

    public A withApiKey(String apiKey){
            this.apiKey=apiKey; return (A) this;
    }

    public Boolean hasApiKey(){
            return this.apiKey != null;
    }

    public A withNewApiKey(String arg1){
            return (A)withApiKey(new String(arg1));
    }

    public A withNewApiKey(StringBuilder arg1){
            return (A)withApiKey(new String(arg1));
    }

    public A withNewApiKey(StringBuffer arg1){
            return (A)withApiKey(new String(arg1));
    }

    public String getApiOperation(){
            return this.apiOperation;
    }

    public A withApiOperation(String apiOperation){
            this.apiOperation=apiOperation; return (A) this;
    }

    public Boolean hasApiOperation(){
            return this.apiOperation != null;
    }

    public A withNewApiOperation(String arg1){
            return (A)withApiOperation(new String(arg1));
    }

    public A withNewApiOperation(StringBuilder arg1){
            return (A)withApiOperation(new String(arg1));
    }

    public A withNewApiOperation(StringBuffer arg1){
            return (A)withApiOperation(new String(arg1));
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildTimestamp instead.
 * @return The buildable object.
 */
@Deprecated public TimeStamp getTimestamp(){
            return this.timestamp!=null?this.timestamp.build():null;
    }

    public TimeStamp buildTimestamp(){
            return this.timestamp!=null?this.timestamp.build():null;
    }

    public A withTimestamp(TimeStamp timestamp){
            _visitables.get("timestamp").remove(this.timestamp);
            if (timestamp!=null){ this.timestamp= new TimeStampBuilder(timestamp); _visitables.get("timestamp").add(this.timestamp);} return (A) this;
    }

    public Boolean hasTimestamp(){
            return this.timestamp != null;
    }

    public A withNewTimestamp(Integer nanos,Long seconds){
            return (A)withTimestamp(new TimeStamp(nanos, seconds));
    }

    public ApiKeyFluent.TimestampNested<A> withNewTimestamp(){
            return new TimestampNestedImpl();
    }

    public ApiKeyFluent.TimestampNested<A> withNewTimestampLike(TimeStamp item){
            return new TimestampNestedImpl(item);
    }

    public ApiKeyFluent.TimestampNested<A> editTimestamp(){
            return withNewTimestampLike(getTimestamp());
    }

    public ApiKeyFluent.TimestampNested<A> editOrNewTimestamp(){
            return withNewTimestampLike(getTimestamp() != null ? getTimestamp(): new TimeStampBuilder().build());
    }

    public ApiKeyFluent.TimestampNested<A> editOrNewTimestampLike(TimeStamp item){
            return withNewTimestampLike(getTimestamp() != null ? getTimestamp(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ApiKeyFluentImpl that = (ApiKeyFluentImpl) o;
            if (api != null ? !api.equals(that.api) :that.api != null) return false;
            if (apiKey != null ? !apiKey.equals(that.apiKey) :that.apiKey != null) return false;
            if (apiOperation != null ? !apiOperation.equals(that.apiOperation) :that.apiOperation != null) return false;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (timestamp != null ? !timestamp.equals(that.timestamp) :that.timestamp != null) return false;
            return true;
    }


    public class TimestampNestedImpl<N> extends TimeStampFluentImpl<ApiKeyFluent.TimestampNested<N>> implements ApiKeyFluent.TimestampNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TimeStampBuilder builder;
    
            TimestampNestedImpl(TimeStamp item){
                    this.builder = new TimeStampBuilder(this, item);
            }
            TimestampNestedImpl(){
                    this.builder = new TimeStampBuilder(this);
            }
    
    public N and(){
            return (N) ApiKeyFluentImpl.this.withTimestamp(builder.build());
    }
    public N endTimestamp(){
            return and();
    }

}


}
