
package me.snowdrop.istio.mixer.template.authorization;

import java.io.Serializable;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.cexl.TypedValue;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "method",
    "namespace",
    "path",
    "properties",
    "service"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Action implements Serializable
{

    /**
     * 
     */
    @JsonProperty("method")
    @JsonPropertyDescription("")
    private java.lang.String method;
    /**
     * 
     */
    @JsonProperty("namespace")
    @JsonPropertyDescription("")
    private java.lang.String namespace;
    /**
     * 
     */
    @JsonProperty("path")
    @JsonPropertyDescription("")
    private java.lang.String path;
    /**
     * 
     */
    @JsonProperty("properties")
    @JsonPropertyDescription("")
    private Map<String, TypedValue> properties;
    /**
     * 
     */
    @JsonProperty("service")
    @JsonPropertyDescription("")
    private java.lang.String service;
    private final static long serialVersionUID = 8910306104074792355L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Action() {
    }

    /**
     * 
     * @param path
     * @param method
     * @param service
     * @param namespace
     * @param properties
     */
    public Action(java.lang.String method, java.lang.String namespace, java.lang.String path, Map<String, TypedValue> properties, java.lang.String service) {
        super();
        this.method = method;
        this.namespace = namespace;
        this.path = path;
        this.properties = properties;
        this.service = service;
    }

    /**
     * 
     */
    public java.lang.String getMethod() {
        return method;
    }

    /**
     * 
     */
    public void setMethod(java.lang.String method) {
        this.method = method;
    }

    /**
     * 
     */
    public java.lang.String getNamespace() {
        return namespace;
    }

    /**
     * 
     */
    public void setNamespace(java.lang.String namespace) {
        this.namespace = namespace;
    }

    /**
     * 
     */
    public java.lang.String getPath() {
        return path;
    }

    /**
     * 
     */
    public void setPath(java.lang.String path) {
        this.path = path;
    }

    /**
     * 
     */
    public Map<String, TypedValue> getProperties() {
        return properties;
    }

    /**
     * 
     */
    public void setProperties(Map<String, TypedValue> properties) {
        this.properties = properties;
    }

    /**
     * 
     */
    public java.lang.String getService() {
        return service;
    }

    /**
     * 
     */
    public void setService(java.lang.String service) {
        this.service = service;
    }

}
