
package me.snowdrop.istio.mixer.template.authorization;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.internal.MixerTemplate;
import me.snowdrop.istio.api.policy.v1beta1.InstanceParams;


/**
 * 
 */
@MixerTemplate(compiledTemplate = "authorization")
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "action",
    "name",
    "subject"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Authorization implements Serializable, InstanceParams
{

    /**
     * 
     */
    @JsonProperty("action")
    @JsonPropertyDescription("")
    private Action action;
    /**
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("")
    private String name;
    /**
     * 
     */
    @JsonProperty("subject")
    @JsonPropertyDescription("")
    private Subject subject;
    private final static long serialVersionUID = -6612096793524441838L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Authorization() {
    }

    /**
     * 
     * @param subject
     * @param name
     * @param action
     */
    public Authorization(Action action, String name, Subject subject) {
        super();
        this.action = action;
        this.name = name;
        this.subject = subject;
    }

    /**
     * 
     */
    public Action getAction() {
        return action;
    }

    /**
     * 
     */
    public void setAction(Action action) {
        this.action = action;
    }

    /**
     * 
     */
    public String getName() {
        return name;
    }

    /**
     * 
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 
     */
    public Subject getSubject() {
        return subject;
    }

    /**
     * 
     */
    public void setSubject(Subject subject) {
        this.subject = subject;
    }

}
