package me.snowdrop.istio.mixer.template.authorization;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AuthorizationBuilder extends AuthorizationFluentImpl<AuthorizationBuilder> implements VisitableBuilder<Authorization,AuthorizationBuilder>{

    AuthorizationFluent<?> fluent;
    Boolean validationEnabled;

    public AuthorizationBuilder(){
            this(true);
    }
    public AuthorizationBuilder(Boolean validationEnabled){
            this(new Authorization(), validationEnabled);
    }
    public AuthorizationBuilder(AuthorizationFluent<?> fluent){
            this(fluent, true);
    }
    public AuthorizationBuilder(AuthorizationFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Authorization(), validationEnabled);
    }
    public AuthorizationBuilder(AuthorizationFluent<?> fluent,Authorization instance){
            this(fluent, instance, true);
    }
    public AuthorizationBuilder(AuthorizationFluent<?> fluent,Authorization instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAction(instance.getAction()); 
            fluent.withName(instance.getName()); 
            fluent.withSubject(instance.getSubject()); 
            this.validationEnabled = validationEnabled; 
    }
    public AuthorizationBuilder(Authorization instance){
            this(instance,true);
    }
    public AuthorizationBuilder(Authorization instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAction(instance.getAction()); 
            this.withName(instance.getName()); 
            this.withSubject(instance.getSubject()); 
            this.validationEnabled = validationEnabled; 
    }

    public Authorization build(){
            Authorization buildable = new Authorization(fluent.getAction(),fluent.getName(),fluent.getSubject());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AuthorizationBuilder that = (AuthorizationBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
