
package me.snowdrop.istio.mixer.template.authorization;

import java.io.Serializable;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.cexl.TypedValue;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "groups",
    "properties",
    "user"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Subject implements Serializable
{

    /**
     * 
     */
    @JsonProperty("groups")
    @JsonPropertyDescription("")
    private java.lang.String groups;
    /**
     * 
     */
    @JsonProperty("properties")
    @JsonPropertyDescription("")
    private Map<String, TypedValue> properties;
    /**
     * 
     */
    @JsonProperty("user")
    @JsonPropertyDescription("")
    private java.lang.String user;
    private final static long serialVersionUID = -2840802201344467480L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Subject() {
    }

    /**
     * 
     * @param groups
     * @param user
     * @param properties
     */
    public Subject(java.lang.String groups, Map<String, TypedValue> properties, java.lang.String user) {
        super();
        this.groups = groups;
        this.properties = properties;
        this.user = user;
    }

    /**
     * 
     */
    public java.lang.String getGroups() {
        return groups;
    }

    /**
     * 
     */
    public void setGroups(java.lang.String groups) {
        this.groups = groups;
    }

    /**
     * 
     */
    public Map<String, TypedValue> getProperties() {
        return properties;
    }

    /**
     * 
     */
    public void setProperties(Map<String, TypedValue> properties) {
        this.properties = properties;
    }

    /**
     * 
     */
    public java.lang.String getUser() {
        return user;
    }

    /**
     * 
     */
    public void setUser(java.lang.String user) {
        this.user = user;
    }

}
