package me.snowdrop.istio.mixer.template.authorization;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SubjectBuilder extends SubjectFluentImpl<SubjectBuilder> implements VisitableBuilder<Subject,SubjectBuilder>{

    SubjectFluent<?> fluent;
    Boolean validationEnabled;

    public SubjectBuilder(){
            this(true);
    }
    public SubjectBuilder(Boolean validationEnabled){
            this(new Subject(), validationEnabled);
    }
    public SubjectBuilder(SubjectFluent<?> fluent){
            this(fluent, true);
    }
    public SubjectBuilder(SubjectFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Subject(), validationEnabled);
    }
    public SubjectBuilder(SubjectFluent<?> fluent,Subject instance){
            this(fluent, instance, true);
    }
    public SubjectBuilder(SubjectFluent<?> fluent,Subject instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withGroups(instance.getGroups()); 
            fluent.withProperties(instance.getProperties()); 
            fluent.withUser(instance.getUser()); 
            this.validationEnabled = validationEnabled; 
    }
    public SubjectBuilder(Subject instance){
            this(instance,true);
    }
    public SubjectBuilder(Subject instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withGroups(instance.getGroups()); 
            this.withProperties(instance.getProperties()); 
            this.withUser(instance.getUser()); 
            this.validationEnabled = validationEnabled; 
    }

    public Subject build(){
            Subject buildable = new Subject(fluent.getGroups(),fluent.getProperties(),fluent.getUser());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SubjectBuilder that = (SubjectBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
