package me.snowdrop.istio.mixer.template.authorization;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;
import me.snowdrop.istio.api.cexl.TypedValue;

public class SubjectFluentImpl<A extends SubjectFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SubjectFluent<A>{

    private String groups;
    private Map<String,TypedValue> properties;
    private String user;

    public SubjectFluentImpl(){
    }
    public SubjectFluentImpl(Subject instance){
            this.withGroups(instance.getGroups()); 
            this.withProperties(instance.getProperties()); 
            this.withUser(instance.getUser()); 
    }

    public String getGroups(){
            return this.groups;
    }

    public A withGroups(String groups){
            this.groups=groups; return (A) this;
    }

    public Boolean hasGroups(){
            return this.groups != null;
    }

    public A withNewGroups(String arg1){
            return (A)withGroups(new String(arg1));
    }

    public A withNewGroups(StringBuilder arg1){
            return (A)withGroups(new String(arg1));
    }

    public A withNewGroups(StringBuffer arg1){
            return (A)withGroups(new String(arg1));
    }

    public A addToProperties(String key,TypedValue value){
            if(this.properties == null && key != null && value != null) { this.properties = new LinkedHashMap<String,TypedValue>(); }
            if(key != null && value != null) {this.properties.put(key, value);} return (A)this;
    }

    public A addToProperties(Map<String,TypedValue> map){
            if(this.properties == null && map != null) { this.properties = new LinkedHashMap<String,TypedValue>(); }
            if(map != null) { this.properties.putAll(map);} return (A)this;
    }

    public A removeFromProperties(String key){
            if(this.properties == null) { return (A) this; }
            if(key != null && this.properties != null) {this.properties.remove(key);} return (A)this;
    }

    public A removeFromProperties(Map<String,TypedValue> map){
            if(this.properties == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.properties != null){this.properties.remove(key);}}} return (A)this;
    }

    public Map<String,TypedValue> getProperties(){
            return this.properties;
    }

    public A withProperties(Map<String,TypedValue> properties){
            if (properties == null) { this.properties =  null;} else {this.properties = new LinkedHashMap<String,TypedValue>(properties);} return (A) this;
    }

    public Boolean hasProperties(){
            return this.properties != null;
    }

    public String getUser(){
            return this.user;
    }

    public A withUser(String user){
            this.user=user; return (A) this;
    }

    public Boolean hasUser(){
            return this.user != null;
    }

    public A withNewUser(String arg1){
            return (A)withUser(new String(arg1));
    }

    public A withNewUser(StringBuilder arg1){
            return (A)withUser(new String(arg1));
    }

    public A withNewUser(StringBuffer arg1){
            return (A)withUser(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            SubjectFluentImpl that = (SubjectFluentImpl) o;
            if (groups != null ? !groups.equals(that.groups) :that.groups != null) return false;
            if (properties != null ? !properties.equals(that.properties) :that.properties != null) return false;
            if (user != null ? !user.equals(that.user) :that.user != null) return false;
            return true;
    }




}
