package me.snowdrop.istio.mixer.template.checknothing;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CheckNothingBuilder extends CheckNothingFluentImpl<CheckNothingBuilder> implements VisitableBuilder<CheckNothing,CheckNothingBuilder>{

    CheckNothingFluent<?> fluent;
    Boolean validationEnabled;

    public CheckNothingBuilder(){
            this(true);
    }
    public CheckNothingBuilder(Boolean validationEnabled){
            this(new CheckNothing(), validationEnabled);
    }
    public CheckNothingBuilder(CheckNothingFluent<?> fluent){
            this(fluent, true);
    }
    public CheckNothingBuilder(CheckNothingFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new CheckNothing(), validationEnabled);
    }
    public CheckNothingBuilder(CheckNothingFluent<?> fluent,CheckNothing instance){
            this(fluent, instance, true);
    }
    public CheckNothingBuilder(CheckNothingFluent<?> fluent,CheckNothing instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }
    public CheckNothingBuilder(CheckNothing instance){
            this(instance,true);
    }
    public CheckNothingBuilder(CheckNothing instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }

    public CheckNothing build(){
            CheckNothing buildable = new CheckNothing(fluent.getName());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CheckNothingBuilder that = (CheckNothingBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
