
package me.snowdrop.istio.mixer.template.edge;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.TimeStamp;
import me.snowdrop.istio.api.internal.MixerTemplate;
import me.snowdrop.istio.api.policy.v1beta1.InstanceParams;


/**
 * 
 */
@MixerTemplate(compiledTemplate = "edge")
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "apiProtocol",
    "contextProtocol",
    "destinationOwner",
    "destinationServiceName",
    "destinationServiceNamespace",
    "destinationUid",
    "destinationWorkloadName",
    "destinationWorkloadNamespace",
    "name",
    "sourceOwner",
    "sourceUid",
    "sourceWorkloadName",
    "sourceWorkloadNamespace",
    "timestamp"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Edge implements Serializable, InstanceParams
{

    /**
     * 
     */
    @JsonProperty("apiProtocol")
    @JsonPropertyDescription("")
    private String apiProtocol;
    /**
     * 
     */
    @JsonProperty("contextProtocol")
    @JsonPropertyDescription("")
    private String contextProtocol;
    /**
     * 
     */
    @JsonProperty("destinationOwner")
    @JsonPropertyDescription("")
    private String destinationOwner;
    /**
     * 
     */
    @JsonProperty("destinationServiceName")
    @JsonPropertyDescription("")
    private String destinationServiceName;
    /**
     * 
     */
    @JsonProperty("destinationServiceNamespace")
    @JsonPropertyDescription("")
    private String destinationServiceNamespace;
    /**
     * 
     */
    @JsonProperty("destinationUid")
    @JsonPropertyDescription("")
    private String destinationUid;
    /**
     * 
     */
    @JsonProperty("destinationWorkloadName")
    @JsonPropertyDescription("")
    private String destinationWorkloadName;
    /**
     * 
     */
    @JsonProperty("destinationWorkloadNamespace")
    @JsonPropertyDescription("")
    private String destinationWorkloadNamespace;
    /**
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("")
    private String name;
    /**
     * 
     */
    @JsonProperty("sourceOwner")
    @JsonPropertyDescription("")
    private String sourceOwner;
    /**
     * 
     */
    @JsonProperty("sourceUid")
    @JsonPropertyDescription("")
    private String sourceUid;
    /**
     * 
     */
    @JsonProperty("sourceWorkloadName")
    @JsonPropertyDescription("")
    private String sourceWorkloadName;
    /**
     * 
     */
    @JsonProperty("sourceWorkloadNamespace")
    @JsonPropertyDescription("")
    private String sourceWorkloadNamespace;
    /**
     * 
     */
    @JsonProperty("timestamp")
    @JsonPropertyDescription("")
    private TimeStamp timestamp;
    private final static long serialVersionUID = -7388340014131998327L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Edge() {
    }

    /**
     * 
     * @param sourceWorkloadName
     * @param sourceWorkloadNamespace
     * @param destinationServiceName
     * @param destinationUid
     * @param sourceOwner
     * @param apiProtocol
     * @param destinationWorkloadName
     * @param sourceUid
     * @param destinationWorkloadNamespace
     * @param contextProtocol
     * @param name
     * @param destinationOwner
     * @param destinationServiceNamespace
     * @param timestamp
     */
    public Edge(String apiProtocol, String contextProtocol, String destinationOwner, String destinationServiceName, String destinationServiceNamespace, String destinationUid, String destinationWorkloadName, String destinationWorkloadNamespace, String name, String sourceOwner, String sourceUid, String sourceWorkloadName, String sourceWorkloadNamespace, TimeStamp timestamp) {
        super();
        this.apiProtocol = apiProtocol;
        this.contextProtocol = contextProtocol;
        this.destinationOwner = destinationOwner;
        this.destinationServiceName = destinationServiceName;
        this.destinationServiceNamespace = destinationServiceNamespace;
        this.destinationUid = destinationUid;
        this.destinationWorkloadName = destinationWorkloadName;
        this.destinationWorkloadNamespace = destinationWorkloadNamespace;
        this.name = name;
        this.sourceOwner = sourceOwner;
        this.sourceUid = sourceUid;
        this.sourceWorkloadName = sourceWorkloadName;
        this.sourceWorkloadNamespace = sourceWorkloadNamespace;
        this.timestamp = timestamp;
    }

    /**
     * 
     */
    public String getApiProtocol() {
        return apiProtocol;
    }

    /**
     * 
     */
    public void setApiProtocol(String apiProtocol) {
        this.apiProtocol = apiProtocol;
    }

    /**
     * 
     */
    public String getContextProtocol() {
        return contextProtocol;
    }

    /**
     * 
     */
    public void setContextProtocol(String contextProtocol) {
        this.contextProtocol = contextProtocol;
    }

    /**
     * 
     */
    public String getDestinationOwner() {
        return destinationOwner;
    }

    /**
     * 
     */
    public void setDestinationOwner(String destinationOwner) {
        this.destinationOwner = destinationOwner;
    }

    /**
     * 
     */
    public String getDestinationServiceName() {
        return destinationServiceName;
    }

    /**
     * 
     */
    public void setDestinationServiceName(String destinationServiceName) {
        this.destinationServiceName = destinationServiceName;
    }

    /**
     * 
     */
    public String getDestinationServiceNamespace() {
        return destinationServiceNamespace;
    }

    /**
     * 
     */
    public void setDestinationServiceNamespace(String destinationServiceNamespace) {
        this.destinationServiceNamespace = destinationServiceNamespace;
    }

    /**
     * 
     */
    public String getDestinationUid() {
        return destinationUid;
    }

    /**
     * 
     */
    public void setDestinationUid(String destinationUid) {
        this.destinationUid = destinationUid;
    }

    /**
     * 
     */
    public String getDestinationWorkloadName() {
        return destinationWorkloadName;
    }

    /**
     * 
     */
    public void setDestinationWorkloadName(String destinationWorkloadName) {
        this.destinationWorkloadName = destinationWorkloadName;
    }

    /**
     * 
     */
    public String getDestinationWorkloadNamespace() {
        return destinationWorkloadNamespace;
    }

    /**
     * 
     */
    public void setDestinationWorkloadNamespace(String destinationWorkloadNamespace) {
        this.destinationWorkloadNamespace = destinationWorkloadNamespace;
    }

    /**
     * 
     */
    public String getName() {
        return name;
    }

    /**
     * 
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 
     */
    public String getSourceOwner() {
        return sourceOwner;
    }

    /**
     * 
     */
    public void setSourceOwner(String sourceOwner) {
        this.sourceOwner = sourceOwner;
    }

    /**
     * 
     */
    public String getSourceUid() {
        return sourceUid;
    }

    /**
     * 
     */
    public void setSourceUid(String sourceUid) {
        this.sourceUid = sourceUid;
    }

    /**
     * 
     */
    public String getSourceWorkloadName() {
        return sourceWorkloadName;
    }

    /**
     * 
     */
    public void setSourceWorkloadName(String sourceWorkloadName) {
        this.sourceWorkloadName = sourceWorkloadName;
    }

    /**
     * 
     */
    public String getSourceWorkloadNamespace() {
        return sourceWorkloadNamespace;
    }

    /**
     * 
     */
    public void setSourceWorkloadNamespace(String sourceWorkloadNamespace) {
        this.sourceWorkloadNamespace = sourceWorkloadNamespace;
    }

    /**
     * 
     */
    public TimeStamp getTimestamp() {
        return timestamp;
    }

    /**
     * 
     */
    public void setTimestamp(TimeStamp timestamp) {
        this.timestamp = timestamp;
    }

}
