package me.snowdrop.istio.mixer.template.edge;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import me.snowdrop.istio.api.TimeStampBuilder;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.lang.Deprecated;
import me.snowdrop.istio.api.TimeStampFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import com.fasterxml.jackson.core.JsonParser;
import me.snowdrop.istio.api.TimeStamp;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Long;
import java.lang.Object;

public class EdgeFluentImpl<A extends EdgeFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements EdgeFluent<A>{

    private String apiProtocol;
    private String contextProtocol;
    private String destinationOwner;
    private String destinationServiceName;
    private String destinationServiceNamespace;
    private String destinationUid;
    private String destinationWorkloadName;
    private String destinationWorkloadNamespace;
    private String name;
    private String sourceOwner;
    private String sourceUid;
    private String sourceWorkloadName;
    private String sourceWorkloadNamespace;
    private TimeStampBuilder timestamp;

    public EdgeFluentImpl(){
    }
    public EdgeFluentImpl(Edge instance){
            this.withApiProtocol(instance.getApiProtocol()); 
            this.withContextProtocol(instance.getContextProtocol()); 
            this.withDestinationOwner(instance.getDestinationOwner()); 
            this.withDestinationServiceName(instance.getDestinationServiceName()); 
            this.withDestinationServiceNamespace(instance.getDestinationServiceNamespace()); 
            this.withDestinationUid(instance.getDestinationUid()); 
            this.withDestinationWorkloadName(instance.getDestinationWorkloadName()); 
            this.withDestinationWorkloadNamespace(instance.getDestinationWorkloadNamespace()); 
            this.withName(instance.getName()); 
            this.withSourceOwner(instance.getSourceOwner()); 
            this.withSourceUid(instance.getSourceUid()); 
            this.withSourceWorkloadName(instance.getSourceWorkloadName()); 
            this.withSourceWorkloadNamespace(instance.getSourceWorkloadNamespace()); 
            this.withTimestamp(instance.getTimestamp()); 
    }

    public String getApiProtocol(){
            return this.apiProtocol;
    }

    public A withApiProtocol(String apiProtocol){
            this.apiProtocol=apiProtocol; return (A) this;
    }

    public Boolean hasApiProtocol(){
            return this.apiProtocol != null;
    }

    public A withNewApiProtocol(String arg1){
            return (A)withApiProtocol(new String(arg1));
    }

    public A withNewApiProtocol(StringBuilder arg1){
            return (A)withApiProtocol(new String(arg1));
    }

    public A withNewApiProtocol(StringBuffer arg1){
            return (A)withApiProtocol(new String(arg1));
    }

    public String getContextProtocol(){
            return this.contextProtocol;
    }

    public A withContextProtocol(String contextProtocol){
            this.contextProtocol=contextProtocol; return (A) this;
    }

    public Boolean hasContextProtocol(){
            return this.contextProtocol != null;
    }

    public A withNewContextProtocol(String arg1){
            return (A)withContextProtocol(new String(arg1));
    }

    public A withNewContextProtocol(StringBuilder arg1){
            return (A)withContextProtocol(new String(arg1));
    }

    public A withNewContextProtocol(StringBuffer arg1){
            return (A)withContextProtocol(new String(arg1));
    }

    public String getDestinationOwner(){
            return this.destinationOwner;
    }

    public A withDestinationOwner(String destinationOwner){
            this.destinationOwner=destinationOwner; return (A) this;
    }

    public Boolean hasDestinationOwner(){
            return this.destinationOwner != null;
    }

    public A withNewDestinationOwner(String arg1){
            return (A)withDestinationOwner(new String(arg1));
    }

    public A withNewDestinationOwner(StringBuilder arg1){
            return (A)withDestinationOwner(new String(arg1));
    }

    public A withNewDestinationOwner(StringBuffer arg1){
            return (A)withDestinationOwner(new String(arg1));
    }

    public String getDestinationServiceName(){
            return this.destinationServiceName;
    }

    public A withDestinationServiceName(String destinationServiceName){
            this.destinationServiceName=destinationServiceName; return (A) this;
    }

    public Boolean hasDestinationServiceName(){
            return this.destinationServiceName != null;
    }

    public A withNewDestinationServiceName(String arg1){
            return (A)withDestinationServiceName(new String(arg1));
    }

    public A withNewDestinationServiceName(StringBuilder arg1){
            return (A)withDestinationServiceName(new String(arg1));
    }

    public A withNewDestinationServiceName(StringBuffer arg1){
            return (A)withDestinationServiceName(new String(arg1));
    }

    public String getDestinationServiceNamespace(){
            return this.destinationServiceNamespace;
    }

    public A withDestinationServiceNamespace(String destinationServiceNamespace){
            this.destinationServiceNamespace=destinationServiceNamespace; return (A) this;
    }

    public Boolean hasDestinationServiceNamespace(){
            return this.destinationServiceNamespace != null;
    }

    public A withNewDestinationServiceNamespace(String arg1){
            return (A)withDestinationServiceNamespace(new String(arg1));
    }

    public A withNewDestinationServiceNamespace(StringBuilder arg1){
            return (A)withDestinationServiceNamespace(new String(arg1));
    }

    public A withNewDestinationServiceNamespace(StringBuffer arg1){
            return (A)withDestinationServiceNamespace(new String(arg1));
    }

    public String getDestinationUid(){
            return this.destinationUid;
    }

    public A withDestinationUid(String destinationUid){
            this.destinationUid=destinationUid; return (A) this;
    }

    public Boolean hasDestinationUid(){
            return this.destinationUid != null;
    }

    public A withNewDestinationUid(String arg1){
            return (A)withDestinationUid(new String(arg1));
    }

    public A withNewDestinationUid(StringBuilder arg1){
            return (A)withDestinationUid(new String(arg1));
    }

    public A withNewDestinationUid(StringBuffer arg1){
            return (A)withDestinationUid(new String(arg1));
    }

    public String getDestinationWorkloadName(){
            return this.destinationWorkloadName;
    }

    public A withDestinationWorkloadName(String destinationWorkloadName){
            this.destinationWorkloadName=destinationWorkloadName; return (A) this;
    }

    public Boolean hasDestinationWorkloadName(){
            return this.destinationWorkloadName != null;
    }

    public A withNewDestinationWorkloadName(String arg1){
            return (A)withDestinationWorkloadName(new String(arg1));
    }

    public A withNewDestinationWorkloadName(StringBuilder arg1){
            return (A)withDestinationWorkloadName(new String(arg1));
    }

    public A withNewDestinationWorkloadName(StringBuffer arg1){
            return (A)withDestinationWorkloadName(new String(arg1));
    }

    public String getDestinationWorkloadNamespace(){
            return this.destinationWorkloadNamespace;
    }

    public A withDestinationWorkloadNamespace(String destinationWorkloadNamespace){
            this.destinationWorkloadNamespace=destinationWorkloadNamespace; return (A) this;
    }

    public Boolean hasDestinationWorkloadNamespace(){
            return this.destinationWorkloadNamespace != null;
    }

    public A withNewDestinationWorkloadNamespace(String arg1){
            return (A)withDestinationWorkloadNamespace(new String(arg1));
    }

    public A withNewDestinationWorkloadNamespace(StringBuilder arg1){
            return (A)withDestinationWorkloadNamespace(new String(arg1));
    }

    public A withNewDestinationWorkloadNamespace(StringBuffer arg1){
            return (A)withDestinationWorkloadNamespace(new String(arg1));
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    public String getSourceOwner(){
            return this.sourceOwner;
    }

    public A withSourceOwner(String sourceOwner){
            this.sourceOwner=sourceOwner; return (A) this;
    }

    public Boolean hasSourceOwner(){
            return this.sourceOwner != null;
    }

    public A withNewSourceOwner(String arg1){
            return (A)withSourceOwner(new String(arg1));
    }

    public A withNewSourceOwner(StringBuilder arg1){
            return (A)withSourceOwner(new String(arg1));
    }

    public A withNewSourceOwner(StringBuffer arg1){
            return (A)withSourceOwner(new String(arg1));
    }

    public String getSourceUid(){
            return this.sourceUid;
    }

    public A withSourceUid(String sourceUid){
            this.sourceUid=sourceUid; return (A) this;
    }

    public Boolean hasSourceUid(){
            return this.sourceUid != null;
    }

    public A withNewSourceUid(String arg1){
            return (A)withSourceUid(new String(arg1));
    }

    public A withNewSourceUid(StringBuilder arg1){
            return (A)withSourceUid(new String(arg1));
    }

    public A withNewSourceUid(StringBuffer arg1){
            return (A)withSourceUid(new String(arg1));
    }

    public String getSourceWorkloadName(){
            return this.sourceWorkloadName;
    }

    public A withSourceWorkloadName(String sourceWorkloadName){
            this.sourceWorkloadName=sourceWorkloadName; return (A) this;
    }

    public Boolean hasSourceWorkloadName(){
            return this.sourceWorkloadName != null;
    }

    public A withNewSourceWorkloadName(String arg1){
            return (A)withSourceWorkloadName(new String(arg1));
    }

    public A withNewSourceWorkloadName(StringBuilder arg1){
            return (A)withSourceWorkloadName(new String(arg1));
    }

    public A withNewSourceWorkloadName(StringBuffer arg1){
            return (A)withSourceWorkloadName(new String(arg1));
    }

    public String getSourceWorkloadNamespace(){
            return this.sourceWorkloadNamespace;
    }

    public A withSourceWorkloadNamespace(String sourceWorkloadNamespace){
            this.sourceWorkloadNamespace=sourceWorkloadNamespace; return (A) this;
    }

    public Boolean hasSourceWorkloadNamespace(){
            return this.sourceWorkloadNamespace != null;
    }

    public A withNewSourceWorkloadNamespace(String arg1){
            return (A)withSourceWorkloadNamespace(new String(arg1));
    }

    public A withNewSourceWorkloadNamespace(StringBuilder arg1){
            return (A)withSourceWorkloadNamespace(new String(arg1));
    }

    public A withNewSourceWorkloadNamespace(StringBuffer arg1){
            return (A)withSourceWorkloadNamespace(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildTimestamp instead.
 * @return The buildable object.
 */
@Deprecated public TimeStamp getTimestamp(){
            return this.timestamp!=null?this.timestamp.build():null;
    }

    public TimeStamp buildTimestamp(){
            return this.timestamp!=null?this.timestamp.build():null;
    }

    public A withTimestamp(TimeStamp timestamp){
            _visitables.get("timestamp").remove(this.timestamp);
            if (timestamp!=null){ this.timestamp= new TimeStampBuilder(timestamp); _visitables.get("timestamp").add(this.timestamp);} return (A) this;
    }

    public Boolean hasTimestamp(){
            return this.timestamp != null;
    }

    public A withNewTimestamp(Integer nanos,Long seconds){
            return (A)withTimestamp(new TimeStamp(nanos, seconds));
    }

    public EdgeFluent.TimestampNested<A> withNewTimestamp(){
            return new TimestampNestedImpl();
    }

    public EdgeFluent.TimestampNested<A> withNewTimestampLike(TimeStamp item){
            return new TimestampNestedImpl(item);
    }

    public EdgeFluent.TimestampNested<A> editTimestamp(){
            return withNewTimestampLike(getTimestamp());
    }

    public EdgeFluent.TimestampNested<A> editOrNewTimestamp(){
            return withNewTimestampLike(getTimestamp() != null ? getTimestamp(): new TimeStampBuilder().build());
    }

    public EdgeFluent.TimestampNested<A> editOrNewTimestampLike(TimeStamp item){
            return withNewTimestampLike(getTimestamp() != null ? getTimestamp(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            EdgeFluentImpl that = (EdgeFluentImpl) o;
            if (apiProtocol != null ? !apiProtocol.equals(that.apiProtocol) :that.apiProtocol != null) return false;
            if (contextProtocol != null ? !contextProtocol.equals(that.contextProtocol) :that.contextProtocol != null) return false;
            if (destinationOwner != null ? !destinationOwner.equals(that.destinationOwner) :that.destinationOwner != null) return false;
            if (destinationServiceName != null ? !destinationServiceName.equals(that.destinationServiceName) :that.destinationServiceName != null) return false;
            if (destinationServiceNamespace != null ? !destinationServiceNamespace.equals(that.destinationServiceNamespace) :that.destinationServiceNamespace != null) return false;
            if (destinationUid != null ? !destinationUid.equals(that.destinationUid) :that.destinationUid != null) return false;
            if (destinationWorkloadName != null ? !destinationWorkloadName.equals(that.destinationWorkloadName) :that.destinationWorkloadName != null) return false;
            if (destinationWorkloadNamespace != null ? !destinationWorkloadNamespace.equals(that.destinationWorkloadNamespace) :that.destinationWorkloadNamespace != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (sourceOwner != null ? !sourceOwner.equals(that.sourceOwner) :that.sourceOwner != null) return false;
            if (sourceUid != null ? !sourceUid.equals(that.sourceUid) :that.sourceUid != null) return false;
            if (sourceWorkloadName != null ? !sourceWorkloadName.equals(that.sourceWorkloadName) :that.sourceWorkloadName != null) return false;
            if (sourceWorkloadNamespace != null ? !sourceWorkloadNamespace.equals(that.sourceWorkloadNamespace) :that.sourceWorkloadNamespace != null) return false;
            if (timestamp != null ? !timestamp.equals(that.timestamp) :that.timestamp != null) return false;
            return true;
    }


    public class TimestampNestedImpl<N> extends TimeStampFluentImpl<EdgeFluent.TimestampNested<N>> implements EdgeFluent.TimestampNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TimeStampBuilder builder;
    
            TimestampNestedImpl(TimeStamp item){
                    this.builder = new TimeStampBuilder(this, item);
            }
            TimestampNestedImpl(){
                    this.builder = new TimeStampBuilder(this);
            }
    
    public N and(){
            return (N) EdgeFluentImpl.this.withTimestamp(builder.build());
    }
    public N endTimestamp(){
            return and();
    }

}


}
