
package me.snowdrop.istio.mixer.template.listentry;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.cexl.TypedValue;
import me.snowdrop.istio.api.internal.MixerTemplate;
import me.snowdrop.istio.api.policy.v1beta1.InstanceParams;


/**
 * 
 */
@MixerTemplate(compiledTemplate = "listentry")
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "name",
    "value"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class ListEntry implements Serializable, InstanceParams
{

    /**
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("")
    private String name;
    /**
     * 
     */
    @JsonProperty("value")
    @JsonPropertyDescription("")
    private TypedValue value;
    private final static long serialVersionUID = 3214801228849196733L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ListEntry() {
    }

    /**
     * 
     * @param name
     * @param value
     */
    public ListEntry(String name, TypedValue value) {
        super();
        this.name = name;
        this.value = value;
    }

    /**
     * 
     */
    public String getName() {
        return name;
    }

    /**
     * 
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 
     */
    public TypedValue getValue() {
        return value;
    }

    /**
     * 
     */
    public void setValue(TypedValue value) {
        this.value = value;
    }

}
