
package me.snowdrop.istio.mixer.template.logentry;

import java.io.Serializable;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.TimeStamp;
import me.snowdrop.istio.api.internal.MixerTemplate;
import me.snowdrop.istio.api.policy.v1beta1.InstanceParams;


/**
 * 
 */
@MixerTemplate(compiledTemplate = "logentry")
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "monitoredResourceDimensions",
    "monitoredResourceType",
    "name",
    "severity",
    "timestamp",
    "variables"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class LogEntry implements Serializable, InstanceParams
{

    /**
     * 
     */
    @JsonProperty("monitoredResourceDimensions")
    @JsonPropertyDescription("")
    private Map<String, me.snowdrop.istio.api.cexl.TypedValue> monitoredResourceDimensions;
    /**
     * 
     */
    @JsonProperty("monitoredResourceType")
    @JsonPropertyDescription("")
    private java.lang.String monitoredResourceType;
    /**
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("")
    private java.lang.String name;
    /**
     * 
     */
    @JsonProperty("severity")
    @JsonPropertyDescription("")
    private java.lang.String severity;
    /**
     * 
     */
    @JsonProperty("timestamp")
    @JsonPropertyDescription("")
    private TimeStamp timestamp;
    /**
     * 
     */
    @JsonProperty("variables")
    @JsonPropertyDescription("")
    private Map<String, me.snowdrop.istio.api.cexl.TypedValue> variables;
    private final static long serialVersionUID = -3412883638123440125L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public LogEntry() {
    }

    /**
     * 
     * @param severity
     * @param variables
     * @param monitoredResourceType
     * @param name
     * @param monitoredResourceDimensions
     * @param timestamp
     */
    public LogEntry(Map<String, me.snowdrop.istio.api.cexl.TypedValue> monitoredResourceDimensions, java.lang.String monitoredResourceType, java.lang.String name, java.lang.String severity, TimeStamp timestamp, Map<String, me.snowdrop.istio.api.cexl.TypedValue> variables) {
        super();
        this.monitoredResourceDimensions = monitoredResourceDimensions;
        this.monitoredResourceType = monitoredResourceType;
        this.name = name;
        this.severity = severity;
        this.timestamp = timestamp;
        this.variables = variables;
    }

    /**
     * 
     */
    public Map<String, me.snowdrop.istio.api.cexl.TypedValue> getMonitoredResourceDimensions() {
        return monitoredResourceDimensions;
    }

    /**
     * 
     */
    public void setMonitoredResourceDimensions(Map<String, me.snowdrop.istio.api.cexl.TypedValue> monitoredResourceDimensions) {
        this.monitoredResourceDimensions = monitoredResourceDimensions;
    }

    /**
     * 
     */
    public java.lang.String getMonitoredResourceType() {
        return monitoredResourceType;
    }

    /**
     * 
     */
    public void setMonitoredResourceType(java.lang.String monitoredResourceType) {
        this.monitoredResourceType = monitoredResourceType;
    }

    /**
     * 
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * 
     */
    public void setName(java.lang.String name) {
        this.name = name;
    }

    /**
     * 
     */
    public java.lang.String getSeverity() {
        return severity;
    }

    /**
     * 
     */
    public void setSeverity(java.lang.String severity) {
        this.severity = severity;
    }

    /**
     * 
     */
    public TimeStamp getTimestamp() {
        return timestamp;
    }

    /**
     * 
     */
    public void setTimestamp(TimeStamp timestamp) {
        this.timestamp = timestamp;
    }

    /**
     * 
     */
    public Map<String, me.snowdrop.istio.api.cexl.TypedValue> getVariables() {
        return variables;
    }

    /**
     * 
     */
    public void setVariables(Map<String, me.snowdrop.istio.api.cexl.TypedValue> variables) {
        this.variables = variables;
    }

}
