package me.snowdrop.istio.mixer.template.logentry;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import me.snowdrop.istio.api.TimeStampBuilder;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import me.snowdrop.istio.api.TimeStampFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import com.fasterxml.jackson.core.JsonParser;
import me.snowdrop.istio.api.cexl.TypedValue;
import me.snowdrop.istio.api.TimeStamp;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Long;
import java.lang.Object;
import java.util.Map;

public class LogEntryFluentImpl<A extends LogEntryFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements LogEntryFluent<A>{

    private Map<String,TypedValue> monitoredResourceDimensions;
    private String monitoredResourceType;
    private String name;
    private String severity;
    private TimeStampBuilder timestamp;
    private Map<String,TypedValue> variables;

    public LogEntryFluentImpl(){
    }
    public LogEntryFluentImpl(LogEntry instance){
            this.withMonitoredResourceDimensions(instance.getMonitoredResourceDimensions()); 
            this.withMonitoredResourceType(instance.getMonitoredResourceType()); 
            this.withName(instance.getName()); 
            this.withSeverity(instance.getSeverity()); 
            this.withTimestamp(instance.getTimestamp()); 
            this.withVariables(instance.getVariables()); 
    }

    public A addToMonitoredResourceDimensions(String key,TypedValue value){
            if(this.monitoredResourceDimensions == null && key != null && value != null) { this.monitoredResourceDimensions = new LinkedHashMap<String,TypedValue>(); }
            if(key != null && value != null) {this.monitoredResourceDimensions.put(key, value);} return (A)this;
    }

    public A addToMonitoredResourceDimensions(Map<String,TypedValue> map){
            if(this.monitoredResourceDimensions == null && map != null) { this.monitoredResourceDimensions = new LinkedHashMap<String,TypedValue>(); }
            if(map != null) { this.monitoredResourceDimensions.putAll(map);} return (A)this;
    }

    public A removeFromMonitoredResourceDimensions(String key){
            if(this.monitoredResourceDimensions == null) { return (A) this; }
            if(key != null && this.monitoredResourceDimensions != null) {this.monitoredResourceDimensions.remove(key);} return (A)this;
    }

    public A removeFromMonitoredResourceDimensions(Map<String,TypedValue> map){
            if(this.monitoredResourceDimensions == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.monitoredResourceDimensions != null){this.monitoredResourceDimensions.remove(key);}}} return (A)this;
    }

    public Map<String,TypedValue> getMonitoredResourceDimensions(){
            return this.monitoredResourceDimensions;
    }

    public A withMonitoredResourceDimensions(Map<String,TypedValue> monitoredResourceDimensions){
            if (monitoredResourceDimensions == null) { this.monitoredResourceDimensions =  null;} else {this.monitoredResourceDimensions = new LinkedHashMap<String,TypedValue>(monitoredResourceDimensions);} return (A) this;
    }

    public Boolean hasMonitoredResourceDimensions(){
            return this.monitoredResourceDimensions != null;
    }

    public String getMonitoredResourceType(){
            return this.monitoredResourceType;
    }

    public A withMonitoredResourceType(String monitoredResourceType){
            this.monitoredResourceType=monitoredResourceType; return (A) this;
    }

    public Boolean hasMonitoredResourceType(){
            return this.monitoredResourceType != null;
    }

    public A withNewMonitoredResourceType(String arg1){
            return (A)withMonitoredResourceType(new String(arg1));
    }

    public A withNewMonitoredResourceType(StringBuilder arg1){
            return (A)withMonitoredResourceType(new String(arg1));
    }

    public A withNewMonitoredResourceType(StringBuffer arg1){
            return (A)withMonitoredResourceType(new String(arg1));
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    public String getSeverity(){
            return this.severity;
    }

    public A withSeverity(String severity){
            this.severity=severity; return (A) this;
    }

    public Boolean hasSeverity(){
            return this.severity != null;
    }

    public A withNewSeverity(String arg1){
            return (A)withSeverity(new String(arg1));
    }

    public A withNewSeverity(StringBuilder arg1){
            return (A)withSeverity(new String(arg1));
    }

    public A withNewSeverity(StringBuffer arg1){
            return (A)withSeverity(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildTimestamp instead.
 * @return The buildable object.
 */
@Deprecated public TimeStamp getTimestamp(){
            return this.timestamp!=null?this.timestamp.build():null;
    }

    public TimeStamp buildTimestamp(){
            return this.timestamp!=null?this.timestamp.build():null;
    }

    public A withTimestamp(TimeStamp timestamp){
            _visitables.get("timestamp").remove(this.timestamp);
            if (timestamp!=null){ this.timestamp= new TimeStampBuilder(timestamp); _visitables.get("timestamp").add(this.timestamp);} return (A) this;
    }

    public Boolean hasTimestamp(){
            return this.timestamp != null;
    }

    public A withNewTimestamp(Integer nanos,Long seconds){
            return (A)withTimestamp(new TimeStamp(nanos, seconds));
    }

    public LogEntryFluent.TimestampNested<A> withNewTimestamp(){
            return new TimestampNestedImpl();
    }

    public LogEntryFluent.TimestampNested<A> withNewTimestampLike(TimeStamp item){
            return new TimestampNestedImpl(item);
    }

    public LogEntryFluent.TimestampNested<A> editTimestamp(){
            return withNewTimestampLike(getTimestamp());
    }

    public LogEntryFluent.TimestampNested<A> editOrNewTimestamp(){
            return withNewTimestampLike(getTimestamp() != null ? getTimestamp(): new TimeStampBuilder().build());
    }

    public LogEntryFluent.TimestampNested<A> editOrNewTimestampLike(TimeStamp item){
            return withNewTimestampLike(getTimestamp() != null ? getTimestamp(): item);
    }

    public A addToVariables(String key,TypedValue value){
            if(this.variables == null && key != null && value != null) { this.variables = new LinkedHashMap<String,TypedValue>(); }
            if(key != null && value != null) {this.variables.put(key, value);} return (A)this;
    }

    public A addToVariables(Map<String,TypedValue> map){
            if(this.variables == null && map != null) { this.variables = new LinkedHashMap<String,TypedValue>(); }
            if(map != null) { this.variables.putAll(map);} return (A)this;
    }

    public A removeFromVariables(String key){
            if(this.variables == null) { return (A) this; }
            if(key != null && this.variables != null) {this.variables.remove(key);} return (A)this;
    }

    public A removeFromVariables(Map<String,TypedValue> map){
            if(this.variables == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.variables != null){this.variables.remove(key);}}} return (A)this;
    }

    public Map<String,TypedValue> getVariables(){
            return this.variables;
    }

    public A withVariables(Map<String,TypedValue> variables){
            if (variables == null) { this.variables =  null;} else {this.variables = new LinkedHashMap<String,TypedValue>(variables);} return (A) this;
    }

    public Boolean hasVariables(){
            return this.variables != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            LogEntryFluentImpl that = (LogEntryFluentImpl) o;
            if (monitoredResourceDimensions != null ? !monitoredResourceDimensions.equals(that.monitoredResourceDimensions) :that.monitoredResourceDimensions != null) return false;
            if (monitoredResourceType != null ? !monitoredResourceType.equals(that.monitoredResourceType) :that.monitoredResourceType != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (severity != null ? !severity.equals(that.severity) :that.severity != null) return false;
            if (timestamp != null ? !timestamp.equals(that.timestamp) :that.timestamp != null) return false;
            if (variables != null ? !variables.equals(that.variables) :that.variables != null) return false;
            return true;
    }


    public class TimestampNestedImpl<N> extends TimeStampFluentImpl<LogEntryFluent.TimestampNested<N>> implements LogEntryFluent.TimestampNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TimeStampBuilder builder;
    
            TimestampNestedImpl(TimeStamp item){
                    this.builder = new TimeStampBuilder(this, item);
            }
            TimestampNestedImpl(){
                    this.builder = new TimeStampBuilder(this);
            }
    
    public N and(){
            return (N) LogEntryFluentImpl.this.withTimestamp(builder.build());
    }
    public N endTimestamp(){
            return and();
    }

}


}
