
package me.snowdrop.istio.mixer.template.metric;

import java.io.Serializable;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.internal.MixerTemplate;
import me.snowdrop.istio.api.policy.v1beta1.InstanceParams;


/**
 * 
 */
@MixerTemplate(compiledTemplate = "metric")
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "dimensions",
    "monitoredResourceDimensions",
    "monitoredResourceType",
    "name",
    "value"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Metric implements Serializable, InstanceParams
{

    /**
     * 
     */
    @JsonProperty("dimensions")
    @JsonPropertyDescription("")
    private Map<String, me.snowdrop.istio.api.cexl.TypedValue> dimensions;
    /**
     * 
     */
    @JsonProperty("monitoredResourceDimensions")
    @JsonPropertyDescription("")
    private Map<String, me.snowdrop.istio.api.cexl.TypedValue> monitoredResourceDimensions;
    /**
     * 
     */
    @JsonProperty("monitoredResourceType")
    @JsonPropertyDescription("")
    private java.lang.String monitoredResourceType;
    /**
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("")
    private java.lang.String name;
    /**
     * 
     */
    @JsonProperty("value")
    @JsonPropertyDescription("")
    private me.snowdrop.istio.api.cexl.TypedValue value;
    private final static long serialVersionUID = -6092370012133658152L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Metric() {
    }

    /**
     * 
     * @param monitoredResourceType
     * @param name
     * @param monitoredResourceDimensions
     * @param value
     * @param dimensions
     */
    public Metric(Map<String, me.snowdrop.istio.api.cexl.TypedValue> dimensions, Map<String, me.snowdrop.istio.api.cexl.TypedValue> monitoredResourceDimensions, java.lang.String monitoredResourceType, java.lang.String name, me.snowdrop.istio.api.cexl.TypedValue value) {
        super();
        this.dimensions = dimensions;
        this.monitoredResourceDimensions = monitoredResourceDimensions;
        this.monitoredResourceType = monitoredResourceType;
        this.name = name;
        this.value = value;
    }

    /**
     * 
     */
    public Map<String, me.snowdrop.istio.api.cexl.TypedValue> getDimensions() {
        return dimensions;
    }

    /**
     * 
     */
    public void setDimensions(Map<String, me.snowdrop.istio.api.cexl.TypedValue> dimensions) {
        this.dimensions = dimensions;
    }

    /**
     * 
     */
    public Map<String, me.snowdrop.istio.api.cexl.TypedValue> getMonitoredResourceDimensions() {
        return monitoredResourceDimensions;
    }

    /**
     * 
     */
    public void setMonitoredResourceDimensions(Map<String, me.snowdrop.istio.api.cexl.TypedValue> monitoredResourceDimensions) {
        this.monitoredResourceDimensions = monitoredResourceDimensions;
    }

    /**
     * 
     */
    public java.lang.String getMonitoredResourceType() {
        return monitoredResourceType;
    }

    /**
     * 
     */
    public void setMonitoredResourceType(java.lang.String monitoredResourceType) {
        this.monitoredResourceType = monitoredResourceType;
    }

    /**
     * 
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * 
     */
    public void setName(java.lang.String name) {
        this.name = name;
    }

    /**
     * 
     */
    public me.snowdrop.istio.api.cexl.TypedValue getValue() {
        return value;
    }

    /**
     * 
     */
    public void setValue(me.snowdrop.istio.api.cexl.TypedValue value) {
        this.value = value;
    }

}
