
package me.snowdrop.istio.mixer.template.quota;

import java.io.Serializable;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.cexl.TypedValue;
import me.snowdrop.istio.api.internal.MixerTemplate;
import me.snowdrop.istio.api.policy.v1beta1.InstanceParams;


/**
 * 
 */
@MixerTemplate(compiledTemplate = "quota")
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "dimensions",
    "name"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Quota implements Serializable, InstanceParams
{

    /**
     * 
     */
    @JsonProperty("dimensions")
    @JsonPropertyDescription("")
    private Map<String, TypedValue> dimensions;
    /**
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("")
    private java.lang.String name;
    private final static long serialVersionUID = -3568453599835366199L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Quota() {
    }

    /**
     * 
     * @param name
     * @param dimensions
     */
    public Quota(Map<String, TypedValue> dimensions, java.lang.String name) {
        super();
        this.dimensions = dimensions;
        this.name = name;
    }

    /**
     * 
     */
    public Map<String, TypedValue> getDimensions() {
        return dimensions;
    }

    /**
     * 
     */
    public void setDimensions(Map<String, TypedValue> dimensions) {
        this.dimensions = dimensions;
    }

    /**
     * 
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * 
     */
    public void setName(java.lang.String name) {
        this.name = name;
    }

}
