package me.snowdrop.istio.mixer.template.quota;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;
import me.snowdrop.istio.api.cexl.TypedValue;

public class QuotaFluentImpl<A extends me.snowdrop.istio.mixer.template.quota.QuotaFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements me.snowdrop.istio.mixer.template.quota.QuotaFluent<A>{

    private Map<String,TypedValue> dimensions;
    private String name;

    public QuotaFluentImpl(){
    }
    public QuotaFluentImpl(me.snowdrop.istio.mixer.template.quota.Quota instance){
            this.withDimensions(instance.getDimensions()); 
            this.withName(instance.getName()); 
    }

    public A addToDimensions(String key,TypedValue value){
            if(this.dimensions == null && key != null && value != null) { this.dimensions = new LinkedHashMap<String,TypedValue>(); }
            if(key != null && value != null) {this.dimensions.put(key, value);} return (A)this;
    }

    public A addToDimensions(Map<String,TypedValue> map){
            if(this.dimensions == null && map != null) { this.dimensions = new LinkedHashMap<String,TypedValue>(); }
            if(map != null) { this.dimensions.putAll(map);} return (A)this;
    }

    public A removeFromDimensions(String key){
            if(this.dimensions == null) { return (A) this; }
            if(key != null && this.dimensions != null) {this.dimensions.remove(key);} return (A)this;
    }

    public A removeFromDimensions(Map<String,TypedValue> map){
            if(this.dimensions == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.dimensions != null){this.dimensions.remove(key);}}} return (A)this;
    }

    public Map<String,TypedValue> getDimensions(){
            return this.dimensions;
    }

    public A withDimensions(Map<String,TypedValue> dimensions){
            if (dimensions == null) { this.dimensions =  null;} else {this.dimensions = new LinkedHashMap<String,TypedValue>(dimensions);} return (A) this;
    }

    public Boolean hasDimensions(){
            return this.dimensions != null;
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            QuotaFluentImpl that = (QuotaFluentImpl) o;
            if (dimensions != null ? !dimensions.equals(that.dimensions) :that.dimensions != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            return true;
    }




}
