package me.snowdrop.istio.mixer.template.reportnothing;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ReportNothingBuilder extends ReportNothingFluentImpl<ReportNothingBuilder> implements VisitableBuilder<ReportNothing,ReportNothingBuilder>{

    ReportNothingFluent<?> fluent;
    Boolean validationEnabled;

    public ReportNothingBuilder(){
            this(true);
    }
    public ReportNothingBuilder(Boolean validationEnabled){
            this(new ReportNothing(), validationEnabled);
    }
    public ReportNothingBuilder(ReportNothingFluent<?> fluent){
            this(fluent, true);
    }
    public ReportNothingBuilder(ReportNothingFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ReportNothing(), validationEnabled);
    }
    public ReportNothingBuilder(ReportNothingFluent<?> fluent,ReportNothing instance){
            this(fluent, instance, true);
    }
    public ReportNothingBuilder(ReportNothingFluent<?> fluent,ReportNothing instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }
    public ReportNothingBuilder(ReportNothing instance){
            this(instance,true);
    }
    public ReportNothingBuilder(ReportNothing instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }

    public ReportNothing build(){
            ReportNothing buildable = new ReportNothing(fluent.getName());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ReportNothingBuilder that = (ReportNothingBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
